/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk.v2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.fbpk.FBPK_Constants;
import ghidra.file.formats.android.fbpk.FBPK_Partition;
import ghidra.file.formats.android.fbpk.FBPT;
import ghidra.file.formats.android.fbpk.v2.FBPTv2;
import ghidra.file.formats.android.fbpk.v2.UFPK;
import ghidra.file.formats.android.fbpk.v2.UFSM;
import ghidra.file.formats.android.fbpk.v2.UFSP;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class FBPKv2_Partition
extends FBPK_Partition {
    private long offset;
    private int unknown1;
    private int size;
    private int unknown2;
    private int paritionType;
    private int unknown3;
    private FBPT fbpt;
    private UFPK ufpk;
    private UFSM ufsm;
    private UFSP ufsp;

    public FBPKv2_Partition(BinaryReader reader) throws IOException {
        long start = reader.getPointerIndex();
        this.type = reader.readNextInt();
        this.name = reader.readNextAsciiString(76);
        this.offset = reader.readNextInt();
        this.unknown1 = reader.readNextInt();
        this.size = reader.readNextInt();
        this.unknown2 = reader.readNextInt();
        this.paritionType = reader.readNextInt();
        this.unknown3 = reader.readNextInt();
        this.headerSize = (int)(reader.getPointerIndex() - start);
        BinaryReader clone = reader.clone(this.offset);
        if (this.paritionType == 0) {
            if (this.name.startsWith("partition:")) {
                this.fbpt = new FBPTv2(clone);
            }
            if (this.name.equals("ufs")) {
                if (clone.peekNextInt() == 1297303125) {
                    this.ufsm = new UFSM(clone);
                } else if (clone.peekNextInt() == 1347634773) {
                    this.ufsp = new UFSP(clone);
                }
            }
            if (this.name.equals(FBPK_Constants.V2_UFSFWUPDATE)) {
                this.ufpk = new UFPK(clone);
            }
        }
    }

    @Override
    public long getDataStartOffset() {
        return this.offset;
    }

    @Override
    public int getDataSize() {
        return this.size;
    }

    public FBPT getFBPT() {
        return this.fbpt;
    }

    public UFPK getUFPK() {
        return this.ufpk;
    }

    public UFSM getUFSM() {
        return this.ufsm;
    }

    public UFSP getUFSP() {
        return this.ufsp;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public int getParitionType() {
        return this.paritionType;
    }

    public int getUnknown3() {
        return this.unknown3;
    }

    @Override
    public boolean isFile() {
        return this.paritionType == 1;
    }

    @Override
    public int getOffsetToNextPartitionTable() {
        return 0;
    }

    @Override
    public void markup(Program program, Address address, TaskMonitor monitor, MessageLog log) throws Exception {
        super.markup(program, address, monitor, log);
        this.processFBPT(program, monitor, log);
        this.processUFPK(program, monitor, log);
        this.processUFSM(program, monitor, log);
        this.processUFSP(program, monitor, log);
    }

    private void processFBPT(Program program, TaskMonitor monitor, MessageLog log) throws Exception {
        Address address = program.getMinAddress().getNewAddress(this.offset);
        if (this.fbpt != null) {
            this.fbpt.processFBPT(program, address, monitor, log);
        }
    }

    private void processUFPK(Program program, TaskMonitor monitor, MessageLog log) throws Exception {
        Address address = program.getMinAddress().getNewAddress(this.offset);
        if (this.ufpk != null) {
            DataType dataType = this.ufpk.toDataType();
            Data data = program.getListing().createData(address, dataType);
            if (data == null) {
                log.appendMsg("Unable to apply 1263552085 data, stopping - " + String.valueOf(address));
            }
        }
    }

    private void processUFSM(Program program, TaskMonitor monitor, MessageLog log) throws Exception {
        Address address = program.getMinAddress().getNewAddress(this.offset);
        if (this.ufsm != null) {
            DataType dataType = this.ufsm.toDataType();
            Data data = program.getListing().createData(address, dataType);
            if (data == null) {
                log.appendMsg("Unable to apply UFSM data, stopping - " + String.valueOf(address));
            }
        }
    }

    private void processUFSP(Program program, TaskMonitor monitor, MessageLog log) throws Exception {
        Address address = program.getMinAddress().getNewAddress(this.offset);
        if (this.ufsp != null) {
            DataType dataType = this.ufsp.toDataType();
            Data data = program.getListing().createData(address, dataType);
            if (data == null) {
                log.appendMsg("Unable to apply UFSP data, stopping - " + String.valueOf(address));
            }
        }
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(FBPKv2_Partition.class.getSimpleName(), 0);
        struct.add(DWORD, "type", null);
        struct.add(STRING, 76, "name", null);
        struct.add(DWORD, "offset", null);
        struct.add(DWORD, "unknown1", null);
        struct.add(DWORD, "size", null);
        struct.add(DWORD, "unknown2", null);
        struct.add(DWORD, "paritionType", null);
        struct.add(DWORD, "unknown3", null);
        return struct;
    }
}

