/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.space;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;
import java.io.PrintStream;

public class OtherSpace
extends AddrSpace {
    public OtherSpace(Translate t, String nm, int ind) {
        super(t, spacetype.IPTR_PROCESSOR, nm, 8, 1, ind, 0, 0);
        this.clearFlags(2);
        this.setFlags(512);
    }

    public OtherSpace(Translate t) {
        super(t, spacetype.IPTR_PROCESSOR);
        this.clearFlags(2);
        this.setFlags(512);
    }

    @Override
    public int printRaw(PrintStream s, long offset) {
        s.append("0x");
        s.append(Long.toHexString(offset));
        return this.getTrans().getDefaultSize();
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_SPACE_OTHER);
        this.encode_basic_attributes(encoder);
        encoder.closeElement(SlaFormat.ELEM_SPACE_OTHER);
    }
}

