/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.validator;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import ghidra.app.plugin.core.analysis.validator.PostAnalysisValidator;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;

public class DecompilerParameterIDValidator
extends PostAnalysisValidator {
    private static final String NAME = "Decompiler Parameter ID Validator";
    public static final String MIN_NUM_FUNCS = "Minimum analysis threshold (% of funcs)";
    public static final int MIN_NUM_FUNCS_DEFAULT = 1;

    public DecompilerParameterIDValidator(Program program) {
        super(program);
    }

    public ConditionResult doRun(TaskMonitor monitor) {
        int threshold = 1;
        ConditionStatus status = ConditionStatus.Passed;
        StringBuilder warnings = new StringBuilder();
        int number = DecompilerParameterIDValidator.checkNumberAnalyzed(this.program, monitor);
        if (number < threshold) {
            status = ConditionStatus.Warning;
            warnings.append(this.program.getDomainFile().getName() + " number of functions with signatures from the decompiler parameter id analyzer = " + number + "\n");
        }
        return new ConditionResult(status, warnings.toString());
    }

    private static int checkNumberAnalyzed(Program prog, TaskMonitor monitor) {
        FunctionIterator funcIter = prog.getFunctionManager().getFunctions(true);
        int numFuncsWithParameterID = 0;
        monitor.setIndeterminate(false);
        monitor.initialize((long)prog.getFunctionManager().getFunctionCount());
        while (funcIter.hasNext() && !monitor.isCancelled()) {
            SourceType signatureSource;
            monitor.incrementProgress(1L);
            Function func = (Function)funcIter.next();
            Address address = func.getEntryPoint();
            Instruction inst = prog.getListing().getInstructionAt(address);
            if (inst == null || (signatureSource = func.getSignatureSource()) != SourceType.ANALYSIS) continue;
            ++numFuncsWithParameterID;
        }
        return numFuncsWithParameterID;
    }

    public String getDescription() {
        return "Make sure at least 1 function(s) have signatures from the decompiler parameter id analyzer";
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return this.getName();
    }
}

