/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;

class DirectoryListModel
extends AbstractListModel<File> {
    private List<File> fileList = new ArrayList<File>();

    DirectoryListModel() {
    }

    @Override
    public File getElementAt(int index) {
        return this.fileList.get(index);
    }

    public File set(int index, File file) {
        File oldFile = this.fileList.set(index, file);
        this.fireContentsChanged(this, index, index);
        return oldFile;
    }

    boolean contains(File file) {
        return this.fileList.contains(file);
    }

    void insert(File file) {
        this.fileList.add(file);
        int index = this.fileList.size() - 1;
        this.fireIntervalAdded(this, index, index);
    }

    void setFiles(List<File> newFileList) {
        int size = this.fileList.size();
        this.fileList.clear();
        this.fireIntervalRemoved(this, 0, size);
        if (newFileList.size() != 0) {
            this.fileList.addAll(newFileList);
            this.fireIntervalAdded(this, 0, this.fileList.size() - 1);
        }
    }

    File getFile(int index) {
        if (index >= 0 && index < this.fileList.size()) {
            return this.fileList.get(index);
        }
        return null;
    }

    void update() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    int indexOfFile(File file) {
        return this.fileList.indexOf(file);
    }

    public List<File> getAllFiles() {
        return new ArrayList<File>(this.fileList);
    }

    @Override
    public int getSize() {
        return this.fileList.size();
    }
}

