/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import ghidra.app.plugin.core.diff.DiffGoToService;
import ghidra.app.plugin.core.diff.DiffProgramManager;
import ghidra.app.plugin.core.diff.ProgramDiffPlugin;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.ServiceListener;

public class DiffServiceProvider
implements ServiceProvider {
    private ServiceProvider serviceProvider;
    private ProgramDiffPlugin programDiffPlugin;
    private DiffProgramManager diffProgramManager;
    private DiffGoToService diffGoToService;

    DiffServiceProvider(ServiceProvider serviceProvider, ProgramDiffPlugin programDiffPlugin) {
        this.serviceProvider = serviceProvider;
        this.programDiffPlugin = programDiffPlugin;
        this.diffProgramManager = new DiffProgramManager(this.programDiffPlugin);
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        this.diffGoToService = new DiffGoToService(goToService, programDiffPlugin);
    }

    public void addServiceListener(ServiceListener listener) {
        this.serviceProvider.addServiceListener(listener);
    }

    public <T> T getService(Class<T> serviceClass) {
        if (serviceClass == ProgramManager.class) {
            return serviceClass.cast(this.diffProgramManager);
        }
        if (serviceClass == GoToService.class) {
            return serviceClass.cast(this.diffGoToService);
        }
        return (T)this.serviceProvider.getService(serviceClass);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.serviceProvider.removeServiceListener(listener);
    }
}

