/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.ctadl;

import generic.jar.ResourceFile;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.plugin.core.decompiler.taint.AbstractTaintState;
import ghidra.app.plugin.core.decompiler.taint.TaintLabel;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptLoadException;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.services.ConsoleService;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighVariable;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.List;

public class CTADLTaintState
extends AbstractTaintState {
    public CTADLTaintState(TaintPlugin plugin) {
        super(plugin);
        ENGINE_NAME = "ctadl";
    }

    @Override
    public void buildQuery(List<String> paramList, Path engine, File indexDBFile, String indexDirectory) {
        paramList.add(engine.toString());
        paramList.add("--directory");
        paramList.add(indexDirectory);
        paramList.add("query");
        TaintPlugin.TaintDirection direction = this.taintOptions.getTaintDirection();
        if (!((Object)((Object)direction)).equals((Object)TaintPlugin.TaintDirection.DEFAULT)) {
            paramList.add("--compute-slices");
            switch (this.taintOptions.getTaintDirection()) {
                case BOTH: {
                    paramList.add("all");
                    break;
                }
                case FORWARD: {
                    paramList.add("fwd");
                    break;
                }
                case BACKWARD: {
                    paramList.add("bwd");
                    break;
                }
            }
        }
        paramList.add("--no-compile-analysis");
        paramList.add("-j8");
        paramList.add("--format=" + this.taintOptions.getTaintOutputForm().toString());
    }

    @Override
    public void buildIndex(List<String> paramList, String engine_path, String facts_path, String indexDirectory) {
        paramList.add(engine_path);
        paramList.add("--directory");
        paramList.add(indexDirectory);
        paramList.add("index");
        paramList.add("-j8");
        paramList.add("-f");
        paramList.add(facts_path);
    }

    @Override
    public GhidraScript getExportScript(ConsoleService console, boolean perFunction) {
        String scriptName = this.getScriptName(perFunction);
        BundleHost bundleHost = GhidraScriptUtil.acquireBundleHostReference();
        for (ResourceFile dir : bundleHost.getBundleFiles()) {
            ResourceFile scriptFile;
            if (!dir.isDirectory() || !(scriptFile = new ResourceFile(dir, scriptName)).exists()) continue;
            GhidraScriptProvider provider = GhidraScriptUtil.getProvider((ResourceFile)scriptFile);
            try {
                return provider.getScriptInstance(scriptFile, console.getStdErr());
            }
            catch (GhidraScriptLoadException e) {
                console.addErrorMessage("", "Unable to load script: " + scriptName);
                console.addErrorMessage("", "  detail: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("Script does not exist: " + scriptName);
    }

    protected String getScriptName(boolean perFunction) {
        return perFunction ? "ExportPCodeForSingleFunction.java" : "ExportPCodeForCTADL.java";
    }

    @Override
    protected void writeHeader(PrintWriter writer) {
        writer.println("#include \"pcode/taintquery.dl\"");
    }

    @Override
    protected void writeRule(PrintWriter writer, TaintLabel mark, boolean isSource) {
        boolean functionLevel;
        Boolean allAccess = this.taintOptions.getTaintUseAllAccess();
        String method = isSource ? "TaintSource" : "LeakingSink";
        Address addr = mark.getAddress();
        boolean bl = functionLevel = mark.getVarnodeAddress() == null;
        if (mark.getFunctionName() == null) {
            return;
        }
        ClangToken token = mark.getToken();
        if (token instanceof ClangFuncNameToken) {
            writer.println(method + "Vertex(\"" + mark.getLabel() + "\", vn, p) :-");
            writer.println("\tHFUNC_NAME(f, \"" + mark.getFunctionName() + "\"),");
            writer.println("\tCFunction_FormalParam(f, n, vn),");
            writer.println("\tCReturnParameter(n),");
            writer.println("\tVertex(vn, p).");
        } else {
            ClangFieldToken ftoken;
            ClangVariableToken vtoken;
            HighVariable hv = mark.getHighVariable();
            String pathConstraint = null;
            if (hv == null && token instanceof ClangFieldToken && (vtoken = TaintState.getParentToken(ftoken = (ClangFieldToken)token)) != null) {
                hv = vtoken.getHighVariable();
                pathConstraint = token.getText();
                token = vtoken;
            }
            writer.println(method + "Vertex(\"" + mark.getLabel() + "\", vn, p) :-");
            writer.println("\t((HFUNC_NAME(m, \"" + mark.getFunctionName() + "\"),");
            writer.println("\tCVar_InFunction(vn, m)) ; CVar_isGlobal(vn)),");
            if (!functionLevel && !mark.bySymbol()) {
                writer.println("\t(PCODE_INPUT(i, _, vn) ; PCODE_OUTPUT(i, vn)),");
                writer.println("\tPCODE_TARGET(i, " + addr.getOffset() + "),");
            }
            if (mark.bySymbol() && hv != null) {
                writer.println("\t((SYMBOL_NAME(sym, \"" + token.getText() + "\"),");
                writer.println("\tSYMBOL_HVAR(sym, hv),");
                writer.println("\tVNODE_HVAR(vn, hv));");
                writer.println("\tCVar_SourceInfo(vn, SOURCE_INFO_NAME_KEY, \"" + TaintState.varName(token, false) + "\")),");
            } else if (mark.bySymbol()) {
                writer.println("\tSYMBOL_NAME(sym, \"" + token.getText() + "\"),");
                writer.println("\tSYMBOL_HVAR(sym, hv),");
                writer.println("\tVNODE_HVAR(vn, hv),");
            } else if (hv != null) {
                writer.println("\tCVar_SourceInfo(vn, SOURCE_INFO_NAME_KEY, \"" + TaintState.varName(token, false) + "\"),");
            } else {
                writer.println("\t(CVar_SourceInfo(vn, SOURCE_INFO_NAME_KEY, \"" + TaintState.varName(token, false) + "\");");
            }
            if (pathConstraint != null) {
                writer.println("\tp = \"." + pathConstraint + "\",");
            }
            if (!allAccess.booleanValue()) {
                writer.println("\tp = \"\",");
            }
            writer.println("\tVertex(vn, p).");
        }
    }

    @Override
    public void writeGate(PrintWriter writer, TaintLabel mark) {
        Boolean allAccess = this.taintOptions.getTaintUseAllAccess();
        String method = "TaintSanitizeAll";
        Address addr = mark.getAddress();
        if (mark.getFunctionName() == null) {
            return;
        }
        writer.println(method + "Vertex(vn, p) :-");
        if (!mark.isGlobal()) {
            writer.println("\tHFUNC_NAME(m, \"" + mark.getFunctionName().toString() + "\"),");
            writer.println("\tCVar_InFunction(vn, m),");
        }
        if (addr != null && addr.getOffset() != 0L) {
            writer.println("\tVNODE_PC_ADDRESS(vn, " + addr.getOffset() + "),");
        }
        writer.println("\tCVar_SourceInfo(vn, SOURCE_INFO_NAME_KEY, \"" + TaintState.varName(mark.getToken(), false) + "\"),");
        if (!allAccess.booleanValue()) {
            writer.println("\tp = \"\",");
        }
        writer.println("\tVertex(vn, p).");
    }

    @Override
    protected void writeFooter(PrintWriter writer) {
    }
}

