/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintAbstractDecompilerAction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighVariable;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;

public class TaintSliceTreeAction
extends TaintAbstractDecompilerAction {
    private TaintPlugin plugin;

    public TaintSliceTreeAction(TaintPlugin plugin) {
        super("Show Slice Tree");
        this.setHelpLocation(new HelpLocation("DecompilerTaint", "TaintSliceTree"));
        this.setPopupMenuData(new MenuData(new String[]{"Taint", "Slice Tree"}, "Decompile"));
        this.setDescription("Shows the Taint Slice Trees window for the item under the cursor in the decompilation window.  The new window will not change along with the Listing cursor.");
        this.plugin = plugin;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return this.plugin.getTaintState() != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Msg.info((Object)((Object)this), (Object)("TaintSliceTreeAction action performed: " + context.toString()));
        Program program = context.getProgram();
        if (program == null) {
            return;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        HighVariable highVariable = tokenAtCursor.getHighVariable();
        String hv = highVariable == null ? "HV NULL" : highVariable.toString();
        Msg.info((Object)((Object)this), (Object)("TaintSliceTreeAction action performed.\n\tProgram: " + program.toString() + "\n\tClangToken: " + tokenAtCursor.toString() + "\n\tHighVariable: " + hv));
        if (highVariable != null) {
            this.plugin.showOrCreateNewSliceTree(program, tokenAtCursor, highVariable);
        }
    }
}

