/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.script.rhino;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mozilla.javascript.ClassShutter;

public class RhinoClassShutter
implements ClassShutter {
    private static final List<Pattern> whitelist = new ArrayList<Pattern>();

    public static void addToWhitelist(String regex) throws PatternSyntaxException {
        if (regex == null || (regex = regex.trim()).length() == 0) {
            return;
        }
        for (Pattern p : whitelist) {
            if (!regex.equals(p.pattern())) continue;
            return;
        }
        Pattern p = Pattern.compile(regex);
        whitelist.add(p);
    }

    public static void removeFromWhitelist(String regex) throws PatternSyntaxException {
        if (regex == null || (regex = regex.trim()).length() == 0) {
            return;
        }
        for (Pattern p : whitelist) {
            if (!regex.equals(p.pattern())) continue;
            whitelist.remove(p);
            break;
        }
    }

    public static void loadWhitelist(Reader reader) throws IOException, PatternSyntaxException {
        String s;
        BufferedReader re = new BufferedReader(reader);
        while ((s = re.readLine()) != null) {
            int len = s.length();
            if (len <= 0) continue;
            char c = s.charAt(0);
            if (c == '-') {
                RhinoClassShutter.removeFromWhitelist(s.substring(1, len));
                continue;
            }
            if (c == '+') {
                RhinoClassShutter.addToWhitelist(s.substring(1, len));
                continue;
            }
            if (c == '#') continue;
            RhinoClassShutter.addToWhitelist(s);
        }
    }

    public boolean visibleToScripts(String fullClassName) {
        if (fullClassName.startsWith("org.mozilla.javascript")) {
            return "org.mozilla.javascript.EcmaError".equals(fullClassName);
        }
        if (fullClassName.startsWith("io.sf.carte.echosvg.")) {
            String implPkg = fullClassName.substring(20);
            if (implPkg.startsWith("script")) {
                return false;
            }
            if (implPkg.startsWith("apps")) {
                return false;
            }
            if (implPkg.startsWith("bridge.")) {
                String implBridgeClass = implPkg.substring(7);
                if (implBridgeClass.startsWith("ScriptingEnvironment")) {
                    String c;
                    return implBridgeClass.startsWith("$Window$", 20) && ((c = implBridgeClass.substring(28)).equals("IntervalScriptTimerTask") || c.equals("IntervalRunnableTimerTask") || c.equals("TimeoutScriptTimerTask") || c.equals("TimeoutRunnableTimerTask"));
                }
                if (implBridgeClass.startsWith("BaseScriptingEnvironment")) {
                    return false;
                }
            }
        }
        for (Pattern p : whitelist) {
            if (!p.matcher(fullClassName).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        RhinoClassShutter.addToWhitelist("java.io.PrintStream");
        RhinoClassShutter.addToWhitelist("java.lang.System");
        RhinoClassShutter.addToWhitelist("java.net.URL");
        RhinoClassShutter.addToWhitelist(".*Permission");
        RhinoClassShutter.addToWhitelist("org.w3c.*");
        RhinoClassShutter.addToWhitelist("io.sf.carte.echosvg.w3c.*");
        RhinoClassShutter.addToWhitelist("io.sf.carte.echosvg.anim.*");
        RhinoClassShutter.addToWhitelist("io.sf.carte.echosvg.dom.*");
        RhinoClassShutter.addToWhitelist("io.sf.carte.echosvg.css.*");
        RhinoClassShutter.addToWhitelist("io.sf.carte.echosvg.util.*");
    }
}

