/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.parser.CallbackTokenHandler;
import io.sf.carte.doc.style.css.parser.CommentStore;
import io.sf.carte.doc.style.css.parser.DefaultCommentStore;
import io.sf.carte.doc.style.css.parser.EmptyCommentStore;
import io.sf.carte.doc.style.css.parser.EmptyUnitImpl;
import io.sf.carte.doc.style.css.parser.LexicalProvider;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;

abstract class LexicalCallbackTH
extends CallbackTokenHandler
implements LexicalProvider {
    LexicalUnitImpl currentlu;
    private final CommentStore commentStore;

    LexicalCallbackTH(LexicalProvider caller) {
        super(caller);
        this.currentlu = caller.getCurrentLexicalUnit();
        this.commentStore = this.createCommentStore();
        this.commentStore.set(caller);
    }

    protected CommentStore createCommentStore() {
        if (this.hasParserFlag(Parser.Flag.VALUE_COMMENTS_IGNORE)) {
            return new EmptyCommentStore();
        }
        return new DefaultCommentStore(this);
    }

    @Override
    public boolean hasParserFlag(Parser.Flag flag) {
        return this.getCaller().hasParserFlag(flag);
    }

    @Override
    protected LexicalProvider getCaller() {
        return (LexicalProvider)this.caller;
    }

    @Override
    public void endFunctionArgument(int index) {
        if (this.currentlu != null) {
            this.commentStore.setTrailingComments();
            if (this.currentlu.ownerLexicalUnit != null) {
                this.currentlu = this.currentlu.ownerLexicalUnit;
            }
        } else {
            this.getCaller().endFunctionArgument(index);
        }
    }

    @Override
    public LexicalUnitImpl addPlainLexicalUnit(LexicalUnitImpl lu) {
        this.commentStore.setPrecedingComments(lu);
        if (this.isFunctionOrExpressionContext()) {
            LexicalUnitImpl param = this.currentlu.parameters;
            if (param != null) {
                this.commentStore.setLastParameterTrailingComments(param);
                this.commentStore.setPrecedingComments(lu);
            }
            this.currentlu.addFunctionParameter(lu);
        } else {
            if (this.currentlu != null) {
                this.currentlu.nextLexicalUnit = lu;
                lu.previousLexicalUnit = this.currentlu;
                this.commentStore.setTrailingComments(this.currentlu);
            }
            this.currentlu = lu;
        }
        return lu;
    }

    LexicalUnitImpl addFunctionOrExpressionUnit(LexicalUnitImpl lu) {
        this.commentStore.setPrecedingComments(lu);
        if (this.isFunctionOrExpressionContext()) {
            LexicalUnitImpl param = this.currentlu.parameters;
            if (param != null) {
                this.commentStore.setLastParameterTrailingComments(param);
                this.commentStore.setPrecedingComments(lu);
            }
            this.currentlu.addFunctionParameter(lu);
        } else if (this.currentlu != null) {
            this.currentlu.nextLexicalUnit = lu;
            lu.previousLexicalUnit = this.currentlu;
            this.commentStore.setTrailingComments(this.currentlu);
            this.commentStore.setPrecedingComments(lu);
        }
        this.currentlu = lu;
        return lu;
    }

    @Override
    public LexicalUnitImpl getCurrentLexicalUnit() {
        return this.currentlu;
    }

    @Override
    public void setCurrentLexicalUnit(LexicalUnitImpl currentlu) {
        this.addPlainLexicalUnit(currentlu);
    }

    @Override
    public boolean isFunctionOrExpressionContext() {
        return this.getCaller().isFunctionOrExpressionContext();
    }

    @Override
    public void addEmptyLexicalUnit() {
        EmptyUnitImpl empty = new EmptyUnitImpl();
        this.addPlainLexicalUnit(empty);
    }

    @Override
    void yieldBack() {
        LexicalProvider c = this.getCaller();
        c.setCurrentLexicalUnit(this.getCurrentLexicalUnit());
        super.yieldBack();
    }

    @Override
    public void commented(int index, int commentType, String comment) {
        if (this.buffer.length() != 0) {
            this.processBuffer(index, 12);
            if (commentType == 0) {
                this.commentStore.addTrailingComment(comment);
                this.commentStore.setTrailingComments();
            }
        } else if (commentType == 0) {
            if (!this.isPrevCpWhitespace() && (this.prevcp != 12 || this.commentStore.haveTrailingComments())) {
                this.commentStore.addTrailingComment(comment);
            } else {
                this.commentStore.addPrecedingComment(comment);
                this.commentStore.resetTrailingComments();
            }
        }
        this.prevcp = 12;
    }

    CommentStore getCommentStore() {
        return this.commentStore;
    }

    @Override
    public StringList getPrecedingCommentsAndClear() {
        return this.commentStore.getPrecedingCommentsAndClear();
    }

    @Override
    public StringList getTrailingCommentsAndClear() {
        return this.commentStore.getTrailingCommentsAndClear();
    }
}

