/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSFontFaceRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class FontFaceRule
extends BaseCSSDeclarationRule
implements CSSFontFaceRule {
    private static final long serialVersionUID = 1L;

    public FontFaceRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by) {
        super(abstractCSSStyleSheet, (short)5, by);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.getStyle().getLength() != 0) {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("@font-face{").append(this.getStyle().getMinifiedCssText()).append('}');
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        if (this.getStyle().getLength() != 0) {
            styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
            simpleWriter.write((CharSequence)"@font-face");
            styleFormattingContext.updateContext(this);
            styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
            styleFormattingContext.startStyleDeclaration(simpleWriter);
            this.getStyle().writeCssText(simpleWriter, styleFormattingContext);
            styleFormattingContext.endCurrentContext(this);
            styleFormattingContext.endStyleDeclaration(simpleWriter);
            styleFormattingContext.writeRightCurlyBracket(simpleWriter);
            styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
        }
    }

    @Override
    void startAtRule(String string, String string2) {
        if (!"font-face".equalsIgnoreCase(string)) {
            throw new DOMException(13, "Cannot set rule of type: " + string);
        }
    }
}

