/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.ExternalResourceSecurity;
import io.sf.carte.echosvg.bridge.Messages;
import io.sf.carte.echosvg.util.ParsedURL;
import java.net.URI;
import java.net.URISyntaxException;

public class DefaultExternalResourceSecurity
implements ExternalResourceSecurity {
    public static final String DATA_PROTOCOL = "data";
    public static final String ERROR_CANNOT_ACCESS_DOCUMENT_URL = "DefaultExternalResourceSecurity.error.cannot.access.document.url";
    public static final String ERROR_EXTERNAL_RESOURCE_FROM_DIFFERENT_URL = "DefaultExternalResourceSecurity.error.external.resource.from.different.url";
    protected SecurityException se;

    @Override
    public void checkLoadExternalResource() {
        if (this.se != null) {
            this.se.fillInStackTrace();
            throw this.se;
        }
    }

    public DefaultExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
        if (DATA_PROTOCOL.equals(parsedURL.getProtocol())) {
            return;
        }
        if (parsedURL2 == null) {
            this.se = new SecurityException(Messages.formatMessage(ERROR_CANNOT_ACCESS_DOCUMENT_URL, new Object[]{parsedURL}));
        } else {
            String string;
            String string2 = parsedURL2.getHost();
            String string3 = parsedURL.getHost();
            if (string3 == null && !DATA_PROTOCOL.equals(parsedURL.getProtocol()) && (string = parsedURL.getPath()) != null) {
                try {
                    string3 = new URI(string).getHost();
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RuntimeException(uRISyntaxException);
                }
            }
            if (!(string2 == string3 || string2 != null && string2.equals(string3) || DATA_PROTOCOL.equals(parsedURL.getProtocol()))) {
                this.se = new SecurityException(Messages.formatMessage(ERROR_EXTERNAL_RESOURCE_FROM_DIFFERENT_URL, new Object[]{parsedURL}));
            }
        }
    }
}

