/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.Vec4f;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.util.ArrayList;
import java.util.List;

public abstract class GraphShape
extends Shape {
    protected final int renderModes;
    protected int pass2TexUnit = 0;
    protected GLRegion region = null;
    protected float oshapeSharpness = 0.5f;
    private int regionQuality = 1;
    private final List<GLRegion> dirtyRegions = new ArrayList<GLRegion>();

    public GraphShape(int n) {
        this.renderModes = n;
    }

    public final int getRenderModes() {
        return this.renderModes;
    }

    public final GraphShape setQuality(int n) {
        this.regionQuality = n;
        if (null != this.region) {
            this.region.setQuality(n);
        }
        return this;
    }

    public void setTextureUnit(int n) {
        this.pass2TexUnit = n;
        if (null != this.region) {
            this.region.setTextureUnit(n);
        }
    }

    public final int getQuality() {
        return this.regionQuality;
    }

    public final GraphShape setSharpness(float f) {
        this.oshapeSharpness = f;
        this.markShapeDirty();
        return this;
    }

    public final float getSharpness() {
        return this.oshapeSharpness;
    }

    @Override
    public boolean hasColorChannel() {
        return Region.hasColorChannel(this.renderModes) || Region.hasColorTexture(this.renderModes);
    }

    private final void clearDirtyRegions(GL2ES2 gL2ES2) {
        for (GLRegion gLRegion : this.dirtyRegions) {
            gLRegion.destroy(gL2ES2);
        }
        this.dirtyRegions.clear();
    }

    @Override
    protected final void clearImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.clearImpl(gL2ES2, regionRenderer);
        this.clearDirtyRegions(gL2ES2);
        if (null != this.region) {
            this.region.clear(gL2ES2);
        }
    }

    @Override
    protected final void destroyImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.destroyImpl(gL2ES2, regionRenderer);
        this.clearDirtyRegions(gL2ES2);
        if (null != this.region) {
            this.region.destroy(gL2ES2);
            this.region = null;
        }
    }

    @Override
    protected final void drawImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int[] nArray, Vec4f vec4f) {
        if (null != vec4f) {
            regionRenderer.setColorStatic(vec4f);
        }
        this.region.draw(gL2ES2, regionRenderer, nArray);
    }

    protected void resetGLRegion(GLProfile gLProfile, GL2ES2 gL2ES2, TextureSequence textureSequence, int n, int n2) {
        if (this.hasBorder()) {
            n += 8;
            n2 += 24;
        }
        if (null == this.region) {
            this.region = GLRegion.create(gLProfile, this.renderModes, textureSequence, this.pass2TexUnit, n, n2);
        } else if (null == gL2ES2) {
            this.dirtyRegions.add(this.region);
            this.region = GLRegion.create(gLProfile, this.renderModes, textureSequence, this.pass2TexUnit, n, n2);
        } else {
            this.region.clear(gL2ES2);
            this.region.setBufferCapacity(n, n2);
        }
    }

    protected void resetGLRegion(GLProfile gLProfile, GL2ES2 gL2ES2, TextureSequence textureSequence, OutlineShape outlineShape) {
        int[] nArray = Region.countOutlineShape(outlineShape, new int[2]);
        this.resetGLRegion(gLProfile, gL2ES2, textureSequence, nArray[0], nArray[1]);
    }

    @Override
    protected final void validateImpl(GLProfile gLProfile, GL2ES2 gL2ES2) {
        if (null != gL2ES2) {
            this.clearDirtyRegions(gL2ES2);
        }
        if (this.isShapeDirty()) {
            this.addShapeToRegion(gLProfile, gL2ES2);
            if (this.hasBorder()) {
                this.addBorderOutline();
            } else if (this.hasPadding()) {
                Padding padding = this.getPadding();
                Vec3f vec3f = this.box.getLow();
                Vec3f vec3f2 = this.box.getHigh();
                this.box.resize(vec3f.x() - padding.left, vec3f.y() - padding.bottom, vec3f.z());
                this.box.resize(vec3f2.x() + padding.right, vec3f2.y() + padding.top, vec3f.z());
                this.setRotationPivot(this.box.getCenter());
            }
            this.region.setQuality(this.regionQuality);
        } else if (this.isStateDirty()) {
            this.region.markStateDirty();
        }
    }

    protected void addBorderOutline() {
        OutlineShape outlineShape = new OutlineShape();
        Padding padding = null != this.getPadding() ? this.getPadding() : new Padding();
        float f = this.box.getMinX() - padding.left;
        float f2 = this.box.getMaxX() + padding.right;
        float f3 = this.box.getMinY() - padding.bottom;
        float f4 = this.box.getMaxY() + padding.top;
        float f5 = this.box.getCenter().z();
        outlineShape.moveTo(f, f3, f5);
        outlineShape.lineTo(f2, f3, f5);
        outlineShape.lineTo(f2, f4, f5);
        outlineShape.lineTo(f, f4, f5);
        outlineShape.lineTo(f, f3, f5);
        outlineShape.closeLastOutline(true);
        outlineShape.addEmptyOutline();
        float f6 = this.getBorderThickness();
        outlineShape.moveTo(f + f6, f3 + f6, f5);
        outlineShape.lineTo(f + f6, f4 - f6, f5);
        outlineShape.lineTo(f2 - f6, f4 - f6, f5);
        outlineShape.lineTo(f2 - f6, f3 + f6, f5);
        outlineShape.lineTo(f + f6, f3 + f6, f5);
        outlineShape.closeLastOutline(true);
        outlineShape.setIsQuadraticNurbs();
        outlineShape.setSharpness(this.oshapeSharpness);
        this.region.addOutlineShape(outlineShape, null, this.getBorderColor());
        this.box.resize(outlineShape.getBounds());
        this.setRotationPivot(this.box.getCenter());
    }

    protected void clearImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
    }

    protected void destroyImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
    }

    protected abstract void addShapeToRegion(GLProfile var1, GL2ES2 var2);
}

