/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class LineHeightManager
extends LengthManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 43;
    }

    @Override
    public String getPropertyName() {
        return "line-height";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NORMAL_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                String string = lexicalUnit.getStringValue().toLowerCase(Locale.ROOT);
                if ("normal".equals(string)) {
                    return ValueConstants.NORMAL_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    @Override
    protected int getOrientation() {
        return 1;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getCssValueType() != CSSValue.CssType.TYPED) {
            return value;
        }
        if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
            return new FloatValue(0, 1.1f);
        }
        switch (value.getUnitType()) {
            case 0: {
                return value;
            }
            case 2: {
                return this.fontSizeRelative(cSSStylableElement, string, cSSEngine, styleMap, value.getFloatValue() * 0.01f);
            }
            case 25: {
                float f = value.getFloatValue();
                CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
                if (cSSStylableElement2 != null) {
                    int n2 = cSSEngine.getLineHeightIndex();
                    Value value2 = cSSEngine.getComputedStyle(cSSStylableElement2, null, n2);
                    float f2 = value2.getFloatValue();
                    return new FloatValue(value2.getUnitType(), f * f2);
                }
                return new FloatValue(0, f * 1.1f);
            }
            case 27: {
                float f = value.getFloatValue();
                CSSStylableElement cSSStylableElement3 = (CSSStylableElement)cSSStylableElement.getOwnerDocument().getDocumentElement();
                if (cSSStylableElement3 != cSSStylableElement) {
                    int n3 = cSSEngine.getLineHeightIndex();
                    Value value3 = cSSEngine.getComputedStyle(cSSStylableElement3, null, n3);
                    float f3 = value3.getFloatValue();
                    return new FloatValue(value3.getUnitType(), f * f3);
                }
                return new FloatValue(0, f * 1.1f);
            }
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    private Value fontSizeRelative(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, StyleMap styleMap, float f) {
        int n = cSSEngine.getFontSizeIndex();
        Value value = cSSEngine.getComputedStyle(cSSStylableElement, string, n);
        float f2 = value.getFloatValue();
        return new FloatValue(3, f * f2);
    }
}

