/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class AbstractErrorHandler
implements ErrorHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<Node, String> policyErrorMap = null;
    private HashMap<CSSElement, StyleDeclarationErrorHandler> inlineErrorHandlerMap = null;
    private HashMap<CSSElement, HashMap<String, CSSPropertyValueException>> computedStyleErrors = null;
    private HashMap<CSSElement, List<DOMException>> hintErrors = null;
    private HashMap<Node, CSSMediaException> mediaQueryErrors = null;
    private HashMap<String, IOException> ioErrors = null;
    private HashMap<CSSElement, HashMap<String, CSSPropertyValueException>> computedStyleWarnings = null;
    private HashMap<Node, CSSMediaException> mediaQueryWarnings = null;

    AbstractErrorHandler() {
    }

    @Override
    public StyleDeclarationErrorHandler getInlineStyleErrorHandler(CSSElement cSSElement) {
        StyleDeclarationErrorHandler styleDeclarationErrorHandler;
        if (this.inlineErrorHandlerMap == null) {
            this.inlineErrorHandlerMap = new HashMap();
        }
        if ((styleDeclarationErrorHandler = this.inlineErrorHandlerMap.get(cSSElement)) == null) {
            styleDeclarationErrorHandler = this.getStyleSheetFactory().createInlineStyleErrorHandler(cSSElement);
            this.inlineErrorHandlerMap.put(cSSElement, styleDeclarationErrorHandler);
        }
        return styleDeclarationErrorHandler;
    }

    public Set<CSSElement> getInlineStyleOwners() {
        Set<CSSElement> set;
        if (this.inlineErrorHandlerMap != null && !(set = this.inlineErrorHandlerMap.keySet()).isEmpty()) {
            return set;
        }
        return null;
    }

    protected boolean hasInlineErrors() {
        if (this.inlineErrorHandlerMap != null) {
            for (StyleDeclarationErrorHandler styleDeclarationErrorHandler : this.inlineErrorHandlerMap.values()) {
                if (!styleDeclarationErrorHandler.hasErrors()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasInlineWarnings() {
        if (this.inlineErrorHandlerMap != null) {
            for (StyleDeclarationErrorHandler styleDeclarationErrorHandler : this.inlineErrorHandlerMap.values()) {
                if (!styleDeclarationErrorHandler.hasWarnings()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void policyError(Node node, String string) {
        if (this.policyErrorMap == null) {
            this.policyErrorMap = new HashMap();
        }
        this.policyErrorMap.put(node, string);
    }

    @Override
    public void computedStyleError(CSSElement cSSElement, String string, CSSPropertyValueException cSSPropertyValueException) {
        HashMap<String, CSSPropertyValueException> hashMap;
        if (this.computedStyleErrors == null) {
            this.computedStyleErrors = new HashMap();
            hashMap = new HashMap();
            this.computedStyleErrors.put(cSSElement, hashMap);
        } else {
            hashMap = this.computedStyleErrors.get(cSSElement);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.computedStyleErrors.put(cSSElement, hashMap);
            }
        }
        hashMap.put(string, cSSPropertyValueException);
    }

    @Override
    public void mediaQueryError(Node node, CSSMediaException cSSMediaException) {
        if (this.mediaQueryErrors == null) {
            this.mediaQueryErrors = new HashMap(5);
        }
        this.mediaQueryErrors.put(node, cSSMediaException);
    }

    @Override
    public void ioError(String string, IOException iOException) {
        if (this.ioErrors == null) {
            this.ioErrors = new HashMap();
        }
        this.ioErrors.put(string, iOException);
    }

    @Override
    public boolean hasErrors() {
        return this.hasInlineErrors() || this.hasComputedStyleErrors() || this.hasMediaErrors() || this.hasIOErrors() || this.hasPolicyErrors();
    }

    @Override
    public boolean hasPolicyErrors() {
        return this.policyErrorMap != null;
    }

    @Override
    public boolean hasIOErrors() {
        return this.ioErrors != null;
    }

    @Override
    public boolean hasComputedStyleErrors() {
        return this.computedStyleErrors != null && !this.computedStyleErrors.isEmpty() || this.hintErrors != null && !this.hintErrors.isEmpty();
    }

    @Override
    public boolean hasComputedStyleErrors(CSSElement cSSElement) {
        if (this.computedStyleErrors != null && this.computedStyleErrors.containsKey(cSSElement)) {
            return true;
        }
        return this.hintErrors != null && this.hintErrors.containsKey(cSSElement);
    }

    @Override
    public boolean hasMediaErrors() {
        return this.mediaQueryErrors != null && !this.mediaQueryErrors.isEmpty();
    }

    @Override
    public boolean hasWarnings() {
        return this.hasInlineWarnings() || this.hasComputedStyleWarnings() || this.hasMediaWarnings();
    }

    @Override
    public boolean hasMediaWarnings() {
        return this.mediaQueryWarnings != null && !this.mediaQueryWarnings.isEmpty();
    }

    @Override
    public boolean hasComputedStyleWarnings() {
        return this.computedStyleWarnings != null && !this.computedStyleWarnings.isEmpty();
    }

    @Override
    public boolean hasComputedStyleWarnings(CSSElement cSSElement) {
        return this.computedStyleWarnings != null && this.computedStyleWarnings.containsKey(cSSElement);
    }

    @Override
    public void computedStyleWarning(CSSElement cSSElement, String string, CSSPropertyValueException cSSPropertyValueException) {
        HashMap<String, CSSPropertyValueException> hashMap;
        if (this.computedStyleWarnings == null) {
            this.computedStyleWarnings = new HashMap();
            hashMap = new HashMap();
            this.computedStyleWarnings.put(cSSElement, hashMap);
        } else {
            hashMap = this.computedStyleWarnings.get(cSSElement);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.computedStyleWarnings.put(cSSElement, hashMap);
            }
        }
        hashMap.put(string, cSSPropertyValueException);
    }

    @Override
    public void mediaQueryWarning(Node node, CSSMediaException cSSMediaException) {
        if (this.mediaQueryWarnings == null) {
            this.mediaQueryWarnings = new HashMap(5);
        }
        this.mediaQueryWarnings.put(node, cSSMediaException);
    }

    public String getPolicyError(Node node) {
        return this.policyErrorMap != null ? this.policyErrorMap.get(node) : null;
    }

    public HashMap<String, CSSPropertyValueException> getComputedStyleErrors(CSSElement cSSElement) {
        return this.computedStyleErrors != null ? this.computedStyleErrors.get(cSSElement) : null;
    }

    public List<DOMException> getHintErrors(CSSElement cSSElement) {
        return this.hintErrors != null ? this.hintErrors.get(cSSElement) : null;
    }

    public HashMap<String, CSSPropertyValueException> getComputedStyleWarnings(CSSElement cSSElement) {
        return this.computedStyleWarnings != null ? this.computedStyleWarnings.get(cSSElement) : null;
    }

    public HashMap<Node, String> getPolicyErrors() {
        return this.policyErrorMap;
    }

    public HashMap<Node, CSSMediaException> getMediaErrors() {
        return this.mediaQueryErrors;
    }

    @Deprecated
    public HashMap<String, IOException> getRuleIOErrors() {
        return this.getIOErrors();
    }

    public HashMap<String, IOException> getIOErrors() {
        return this.ioErrors;
    }

    @Override
    public void resetComputedStyleErrors(CSSElement cSSElement) {
        if (this.computedStyleErrors != null) {
            this.computedStyleErrors.remove(cSSElement);
        }
        if (this.hintErrors != null) {
            this.hintErrors.remove(cSSElement);
        }
        if (this.computedStyleWarnings != null) {
            this.computedStyleWarnings.remove(cSSElement);
        }
    }

    @Override
    public void resetComputedStyleErrors() {
        this.computedStyleErrors = null;
        this.hintErrors = null;
        this.computedStyleWarnings = null;
    }

    @Override
    public void presentationalHintError(CSSElement cSSElement, DOMException dOMException) {
        List<DOMException> list;
        if (this.hintErrors == null) {
            this.hintErrors = new HashMap();
            list = new LinkedList<DOMException>();
            this.hintErrors.put(cSSElement, list);
        } else {
            list = this.hintErrors.get(cSSElement);
            if (list == null) {
                list = new LinkedList<DOMException>();
            }
        }
        list.add(dOMException);
    }

    @Override
    public void reset() {
        if (this.inlineErrorHandlerMap != null) {
            Iterator<StyleDeclarationErrorHandler> iterator = this.inlineErrorHandlerMap.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().reset();
            }
        }
        this.resetComputedStyleErrors();
        this.mediaQueryErrors = null;
        this.mediaQueryWarnings = null;
        this.policyErrorMap = null;
        this.ioErrors = null;
    }

    protected abstract AbstractCSSStyleSheetFactory getStyleSheetFactory();
}

