/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

class LetterBasedBreakIterator {
    private CharacterIterator text;

    public void setText(String newText) {
        this.setText(new StringCharacterIterator(newText));
    }

    public void setText(CharacterIterator text) {
        this.text = text;
    }

    public int first() {
        return this.nextBoundary(this.text.first(), false);
    }

    private int nextBoundary(char c, boolean wasLetter) {
        while (c != '\uffff') {
            if (wasLetter != this.isLetter(c)) {
                return this.text.getIndex();
            }
            c = this.text.next();
        }
        return -1;
    }

    public int following(int wordOffset) {
        if (wordOffset <= this.text.getBeginIndex()) {
            return this.first();
        }
        if (wordOffset >= this.text.getEndIndex()) {
            return -1;
        }
        int lastIndex = this.text.getIndex();
        this.text.setIndex(wordOffset);
        boolean wasLetter = this.isLetter(this.text.current());
        int nextBoundary = this.nextBoundary(this.text.next(), wasLetter);
        if (nextBoundary == -1) {
            this.text.setIndex(lastIndex);
        }
        return nextBoundary;
    }

    public int next() {
        boolean wasLetter = this.isLetter(this.text.current());
        return this.nextBoundary(this.text.next(), wasLetter);
    }

    private boolean isLetter(char current) {
        return Character.isDigit(current) || Character.isLetter(current);
    }
}

