/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.DropMode;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.mindmapmode.FilterableJTree;
import org.freeplane.features.icon.mindmapmode.TagCategorySelection;
import org.freeplane.features.icon.mindmapmode.TagCellRenderer;

class JTagTree
extends FilterableJTree {
    private static final long serialVersionUID = 1L;
    private final TagCategories tagCategories;
    private final Font tagFont;

    JTagTree(TagCategories tagCategories, Font tagFont) {
        super(tagCategories.getNodes());
        this.tagCategories = tagCategories;
        this.tagFont = tagFont;
        if (!GraphicsEnvironment.isHeadless()) {
            this.setEditable(true);
            this.getSelectionModel().setSelectionMode(4);
            this.setInvokesStopCellEditing(true);
            this.setDragEnabled(true);
            this.setDropMode(DropMode.ON_OR_INSERT);
            this.setCellRenderer(new TagCellRenderer(tagCategories));
            this.setToggleClickCount(0);
            this.setFont();
        }
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
        return this.tagCategories.containsTag(node);
    }

    @Override
    public void setUI(TreeUI ui) {
        super.setUI(ui);
        if (this.tagFont != null) {
            this.setFont();
        }
    }

    private void setFont() {
        Font font = this.tagFont.deriveFont(this.getFont().getSize2D());
        this.setFont(font);
        Rectangle2D rect = font.getStringBounds("*", 0, 1, new FontRenderContext(new AffineTransform(), true, true));
        double textHeight = rect.getHeight();
        this.setRowHeight((int)Math.ceil(textHeight * 1.4));
    }

    @Override
    public void cancelEditing() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getEditingPath().getLastPathComponent();
        Tag tag = this.tagCategories.tagWithoutCategories(node);
        super.cancelEditing();
        if (tag.isEmpty() && node.isLeaf()) {
            this.tagCategories.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    TagCategorySelection createTransferable() {
        try {
            TreePath[] selectionPaths = this.getSelectedNodePaths();
            if (selectionPaths == null) {
                return null;
            }
            String lastTransferableId = UUID.randomUUID().toString();
            StringWriter tagCategoryWriter = new StringWriter();
            StringWriter tagWriter = new StringWriter();
            for (TreePath treePath : selectionPaths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                this.tagCategories.writeTagCategories(node, "", (Writer)tagCategoryWriter);
                this.tagCategories.writeCategorizedTag(node, tagWriter);
            }
            TagCategorySelection stringSelection = new TagCategorySelection(lastTransferableId, tagCategoryWriter.toString(), tagWriter.toString());
            return stringSelection;
        }
        catch (IOException e) {
            return null;
        }
    }

    TreePath[] getSelectedTagPaths() {
        return this.getSelectedPaths(false);
    }

    TreePath[] getSelectedNodePaths() {
        return this.getSelectedPaths(true);
    }

    private TreePath[] getSelectedPaths(boolean includeNonTags) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        ArrayList<TreePath> filteredPaths = new ArrayList<TreePath>();
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!includeNonTags && !this.tagCategories.containsTag(node)) {
                return null;
            }
            filteredPaths.add(path);
        }
        this.removeDescendants(filteredPaths);
        if (filteredPaths.isEmpty()) {
            return null;
        }
        return filteredPaths.toArray(new TreePath[0]);
    }

    private void removeDescendants(List<TreePath> filteredPaths) {
        block0: for (int i = 0; i < filteredPaths.size(); ++i) {
            TreePath path = filteredPaths.get(i);
            for (int j = 0; j < filteredPaths.size(); ++j) {
                TreePath otherPath;
                if (i == j || !(otherPath = filteredPaths.get(j)).isDescendant(path)) continue;
                filteredPaths.remove(i);
                --i;
                continue block0;
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getMaximumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }
}

