/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadView;

class RandomAccessReadUnbufferedDataStream
extends TTFDataStream {
    private final long length;
    private final RandomAccessRead randomAccessRead;

    RandomAccessReadUnbufferedDataStream(RandomAccessRead randomAccessRead) throws IOException {
        this.length = randomAccessRead.length();
        this.randomAccessRead = randomAccessRead;
    }

    @Override
    public long getCurrentPosition() throws IOException {
        return this.randomAccessRead.getPosition();
    }

    @Override
    public void close() throws IOException {
        this.randomAccessRead.close();
    }

    @Override
    public int read() throws IOException {
        return this.randomAccessRead.read();
    }

    @Override
    public final long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    private int readInt() throws IOException {
        int b1 = this.read();
        int b2 = this.read();
        int b3 = this.read();
        int b4 = this.read();
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.randomAccessRead.seek(pos);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.randomAccessRead.read(b, off, len);
    }

    @Override
    public InputStream getOriginalData() throws IOException {
        return new RandomAccessReadNonClosingInputStream(this.randomAccessRead.createView(0L, this.length));
    }

    @Override
    public long getOriginalDataSize() {
        return this.length;
    }

    @Override
    public RandomAccessRead createSubView(long length) {
        try {
            return this.randomAccessRead.createView(this.randomAccessRead.getPosition(), length);
        }
        catch (IOException ex) {
            assert (false) : "Please implement " + this.randomAccessRead.getClass() + ".createView()";
            return null;
        }
    }

    private static final class RandomAccessReadNonClosingInputStream
    extends InputStream {
        private final RandomAccessReadView randomAccessRead;

        public RandomAccessReadNonClosingInputStream(RandomAccessReadView randomAccessRead) {
            this.randomAccessRead = randomAccessRead;
        }

        @Override
        public int read() throws IOException {
            return this.randomAccessRead.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.randomAccessRead.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.randomAccessRead.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            this.randomAccessRead.seek(this.randomAccessRead.getPosition() + n);
            return n;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

