/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;
import net.infonode.gui.RotatableLabelUI;
import net.infonode.util.Direction;

public class RotatableLabel
extends JLabel {
    private RotatableLabelUI ui = new RotatableLabelUI(Direction.RIGHT);

    public RotatableLabel(String text) {
        super(text);
        this.init();
    }

    public RotatableLabel(String text, Icon icon) {
        super(text, icon, 2);
        this.init();
    }

    private void init() {
        super.setUI(this.ui);
        super.setOpaque(false);
    }

    public Direction getDirection() {
        return this.ui.getDirection();
    }

    public void setDirection(Direction direction) {
        if (this.ui.getDirection() != direction) {
            this.ui.setDirection(direction);
            this.revalidate();
        }
    }

    public void setMirror(boolean mirror) {
        this.ui.setMirror(mirror);
        this.revalidate();
    }

    public boolean isMirror() {
        return this.ui.isMirror();
    }

    @Override
    public void setUI(LabelUI ui) {
    }

    private boolean isVertical() {
        return !this.ui.getDirection().isHorizontal();
    }

    private Dimension rotateDimension(Dimension dim) {
        return dim == null ? null : (this.isVertical() ? new Dimension(dim.height, dim.width) : dim);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.rotateDimension(super.getPreferredSize());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.rotateDimension(super.getMinimumSize());
    }

    @Override
    public Dimension getMaximumSize() {
        return this.rotateDimension(super.getMaximumSize());
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        super.setMinimumSize(this.rotateDimension(minimumSize));
    }

    @Override
    public void setMaximumSize(Dimension maximumSize) {
        super.setMaximumSize(this.rotateDimension(maximumSize));
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(this.rotateDimension(preferredSize));
    }

    @Override
    public void setOpaque(boolean opaque) {
    }
}

