# 看图|deepin-image-viewer|

## 概述


看图是一款小巧的图片查看应用软件。外观时尚、性能流畅，支持多种图片格式，随时想看就看，实用又快捷。


## 使用入门

通过以下方式运行或关闭看图，或者创建看图的快捷方式。

### 运行看图

1. 单击任务栏上的启动器图标 ![deepin_launcher](../common/deepin_launcher.svg)，进入启动器界面。
2. 上下滚动鼠标滚轮浏览或通过搜索，找到看图图标 ![viewer](../common/deepin_image_viewer.svg)，单击运行。
3. 右键单击 ![viewer](../common/deepin_image_viewer.svg)，您可以：
 - 单击 **发送到桌面**，在桌面创建快捷方式。
 - 单击 **发送到任务栏**，将应用程序固定到任务栏。
 - 单击 **开机自动启动**，将应用程序添加到开机启动项，在电脑开机时自动运行该应用。


### 关闭看图

- 在看图界面单击 ![close_icon](../common/close_icon.svg)，退出看图。
- 在任务栏右键单击 ![viewer](../common/deepin_image_viewer.svg)，选择 **关闭所有** ，退出看图。
- 在看图界面单击 ![icon_menu](../common/icon_menu.svg)，选择 **退出** ，退出看图。

### 查看快捷键

在看图界面，使用快捷键 **Ctrl + Shift + ?** 打开快捷键预览界面。熟练地使用快捷键，将大大提升您的操作效率。

![1|hotkey](fig/hotkey.png)

## 图片查看

### 打开图片
采用以下任一方式打开图片。
- 右键单击图片，选择用看图工具打开图片。
- 设置看图为默认的图片查看程序后，双击图片打开。
- 运行看图后，单击 **打开图片**，选择文件打开。
- 运行看图后，拖拽图片到看图界面。
- 直接拖拽图片到看图的图标上。

> ![tips](../common/tips.svg) 窍门：您可以在控制中心中将看图设置为默认的图片查看程序，具体操作请参阅 [默认程序设置](dman:///dde#默认程序设置)。

看图支持查看BMP、ICO、JPG/JPE/JPEG、PNG、TGA、TIF/TIFF、XPM、GIF、WEBP、CR2、NEF、DNG、RAF、MEF、MRW、XBM、SVG、ORF、MNG等多种格式的图片。



### 界面介绍

![1|main](fig/main.png)

| 图标                                                  | 名称       | 说明                   |
| ----------------------------------------------------- | ---------- | ---------------------- |
| ![previous](../common/previous.svg)                   | 上一张     | 显示上一张图片。       |
| ![next](../common/next.svg)                           | 下一张     | 显示下一张图片。       |
| ![adaptimage](../common/adaptimage.svg)               | 1:1视图    | 图片按照实际尺寸显示。 |
| ![adaptscreen](../common/adaptscreen.svg)             | 适应窗口   | 图片适应窗口尺寸显示。 |
| ![ocr](../common/ocr.svg)             | 识别文字 | 识别图片中的文字。 |
| ![clockwiserotation](../common/clockwiserotation.svg) | 顺时针旋转 | 图片顺时针旋转90度。   |
| ![contrarotate](../common/contrarotate.svg)           | 逆时针旋转 | 图片逆时针旋转90度。   |
| ![delete](../common/delete.svg)                       | 删除       | 删除当前图片。         |


> ![notes](../common/notes.svg) 说明：
> - 将鼠标光标置于图片预览区域，按住 **Ctrl** 键，滚动鼠标滚轮切换上一张/下一张图片。
> - 系统图片不支持重命名、旋转和删除的操作。



### 显示/隐藏导航窗口

1. 在看图界面，单击工具栏上的按钮 ![adaptimage](../common/adaptimage.svg) 或滚动鼠标放大图片且当图片超出界面范围时，界面上会出现导航窗口。
2. 拖动导航窗口内的方框，查看该区域的信息。
3. 单击导航窗口上的按钮 **×** 或在右键菜单中选择 **隐藏导航窗口** 来关闭导航窗口。
   
   关闭导航窗口后下次不会再显示，需在右键菜单中选择 **显示导航窗口** 来开启。

![1|main](fig/navigation.png)

### 打印图片

1. 在看图界面，单击鼠标右键。
2. 选择 **打印**。
3. 选择一个打印机，根据需要设置打印属性。
4. 单击 **打印**，将图片发送到打印机进行打印。

### 识别文字

1. 在看图界面，单击工具栏上的按钮 ![ocr](../common/ocr.svg) 或右键单击图片，选择 **识别文字**，弹出图文识别窗口，识别图片中的文字。
2. 您可以对识别出的文字进行编辑、复制或保存为TXT等操作。

![ocr](fig/ocr.png)

### 重命名

1. 在看图界面，单击鼠标右键。
2. 选择 **重命名**。
3. 在弹窗内输入图片名称，单击 **确定** 完成修改。




### 幻灯片放映

1. 在看图界面，单击鼠标右键。
2. 选择 **幻灯片放映**，图片将以幻灯片形式全屏播放。
4. 按下键盘上**Esc** 键退出播放。


### 复制图片

1. 在看图界面，单击鼠标右键。
2. 选择 **复制**。
3. 在桌面或者指定位置，单击鼠标右键。
4. 选择 **粘贴**，将图片文件复制到该位置。

![0|copy](fig/copy.png)


### 旋转图片

1. 在看图界面，单击鼠标右键。
2. 选择 **顺时针旋转/逆时针旋转**。
3. 图片将会顺时针转旋转90°/逆时针旋转90°。
   

![0|rotate](fig/rotate.png)


### 设置为壁纸

1. 在看图界面，单击鼠标右键。
2. 选择 **设为壁纸** ，将当前图片设置为壁纸。

![0|wallpaper](fig/wallpaper.png)

### 在文件管理器中显示
1. 在看图界面，单击鼠标右键。
2. 选择 **在文件管理器中显示**，定位该图片的存储位置。

### 查看图片信息

1. 在看图界面，单击鼠标右键。
2. 选择 **图片信息** ，查看图片详细信息。

![info](fig/info.png)

### 删除图片

通过以下任一方式删除图片：

- 单击工具栏上的图标 ![delete_press](../common/delete.svg)。
- 右键单击图片，选择 **删除**。
- 选择某一张图片，按下键盘上的 **Delete** 键。

## 主菜单

在主菜单中，您可以切换窗口主题、查看帮助手册，了解看图的更多信息。

### 主题

窗口主题包含浅色主题、深色主题和系统主题。

1. 在看图界面，单击 ![icon_menu](../common/icon_menu.svg)。
2. 选择 **主题**，选择一个主题颜色。

### 帮助

查看帮助手册，进一步了解和使用看图。

1. 在看图界面，单击 ![icon_menu](../common/icon_menu.svg)。
2. 选择 **帮助**。
3. 查看看图的帮助手册。

### 关于

1. 在看图界面，单击 ![icon_menu](../common/icon_menu.svg)。
2. 选择 **关于**。
3. 查看看图的版本和介绍。

### 退出

1. 在看图界面，单击 ![icon_menu](../common/icon_menu.svg)。
2. 选择 **退出**。   
