/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.cockroach;

import java.sql.ResultSet;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CockroachSequence
extends PostgreSequence {
    private static final Log log = Log.getLog(CockroachSequence.class);

    public CockroachSequence(PostgreSchema schema, JDBCResultSet dbResult) {
        super(schema, dbResult);
    }

    public CockroachSequence(PostgreSchema catalog) {
        super(catalog);
    }

    @Override
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    @Override
    public void loadAdditionalInfo(DBRProgressMonitor monitor) {
        JDBCResultSet seqResults;
        JDBCPreparedStatement dbSeqStat;
        JDBCSession session;
        PostgreSequence.AdditionalInfo additionalInfo = this.getAdditionalInfo();
        try {
            session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load sequence additional info");
            try {
                dbSeqStat = session.prepareStatement("SELECT * from information_schema.\"sequences\" WHERE sequence_schema=? AND sequence_name=?");
                try {
                    dbSeqStat.setString(1, this.getSchema().getName());
                    dbSeqStat.setString(2, this.getName());
                    seqResults = dbSeqStat.executeQuery();
                    try {
                        if (seqResults.next()) {
                            additionalInfo.setStartValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"start_value"));
                            additionalInfo.setMinValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"minimum_value"));
                            additionalInfo.setMaxValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"maximum_value"));
                            additionalInfo.setIncrementBy(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"increment"));
                        }
                    }
                    finally {
                        if (seqResults != null) {
                            seqResults.close();
                        }
                    }
                }
                finally {
                    if (dbSeqStat != null) {
                        dbSeqStat.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error reading sequence values", (Throwable)e);
        }
        try {
            session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load sequence last value");
            try {
                dbSeqStat = session.prepareStatement("SELECT * from " + this.getFullyQualifiedName(DBPEvaluationContext.DML));
                try {
                    seqResults = dbSeqStat.executeQuery();
                    try {
                        if (seqResults.next()) {
                            additionalInfo.setLastValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"last_value"));
                        }
                    }
                    finally {
                        if (seqResults != null) {
                            seqResults.close();
                        }
                    }
                }
                finally {
                    if (dbSeqStat != null) {
                        dbSeqStat.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error reading sequence las value", (Throwable)e);
        }
        additionalInfo.setLoaded(true);
    }

    @Override
    public boolean supportsCacheAndCycle() {
        return false;
    }
}

