/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.ArrayUtils;

public class DatabaseObjectsTreeManager
implements ICheckStateListener {
    private static final Log log = Log.getLog(DatabaseObjectsTreeManager.class);
    private final DBRRunnableContext runnableContext;
    private final CheckboxTreeViewer viewer;
    private final Class<?>[] targetTypes;
    private final IdentityHashMap<Object, Boolean> checkedElements = new IdentityHashMap();
    private final ViewerFilter[] filters;
    private boolean autoCheckNested = true;

    public DatabaseObjectsTreeManager(DBRRunnableContext runnableContext, CheckboxTreeViewer viewer, Class<?>[] targetTypes) {
        this.runnableContext = runnableContext;
        this.viewer = viewer;
        this.targetTypes = targetTypes;
        this.filters = viewer.getFilters();
        viewer.addCheckStateListener((ICheckStateListener)this);
    }

    public boolean isAutoCheckNested() {
        return this.autoCheckNested;
    }

    public void setAutoCheckNested(boolean autoCheckNested) {
        this.autoCheckNested = autoCheckNested;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.updateElementsCheck(new Object[]{event.getElement()}, event.getChecked(), true, false);
    }

    public void updateElementsCheck(Object[] elements, boolean checked, boolean change, boolean forceNestedCheck) {
        this.checkedElements.clear();
        boolean inWizard = UIUtils.isInWizard((Control)this.viewer.getControl());
        try {
            this.runnableContext.run(!inWizard, true, monitor -> {
                monitor.beginTask("Load sources tree", 100 * elements.length);
                try {
                    for (Object element : elements) {
                        if (!(element instanceof DBNNode)) continue;
                        DBNNode node = (DBNNode)element;
                        monitor.subTask("Search in '" + node.getName() + "'");
                        CollectInfo collectInfo = new CollectInfo();
                        collectInfo.rootElement = node;
                        collectInfo.wasChecked = checked;
                        if (this.autoCheckNested || forceNestedCheck) {
                            this.updateElementHierarchy(monitor, node, collectInfo, change);
                            if (change) {
                                for (DBNNode parent = ((DBNNode)element).getParentNode(); parent != null; parent = parent.getParentNode()) {
                                    this.updateElementHierarchy(monitor, parent, collectInfo, false);
                                    if (parent instanceof DBNDataSource) break;
                                }
                            }
                        }
                        monitor.worked(1);
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Error updating checkbox state", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (Object ce : this.viewer.getCheckedElements()) {
            this.checkedElements.put(ce, Boolean.TRUE);
        }
    }

    private void updateElementHierarchy(DBRProgressMonitor monitor, DBNNode element, CollectInfo collectInfo, boolean change) throws DBException {
        try {
            this.collectChildren(monitor, element, collectInfo, !change);
        }
        catch (DBException e) {
            log.debug((Object)"Error collecting child elements", (Throwable)e);
        }
        UIUtils.syncExec(() -> {
            if (change) {
                for (DBNNode child : collectInfo.targetChildren) {
                    this.viewer.setChecked((Object)child, collectInfo.wasChecked);
                }
            }
            for (DBNNode container : change ? collectInfo.targetContainers : Collections.singletonList(element)) {
                try {
                    DBNNode[] directChildren = container.getChildren(monitor);
                    if (directChildren == null) continue;
                    boolean missingOne = false;
                    boolean missingAll = true;
                    for (DBNNode node : directChildren) {
                        if (!this.viewer.getChecked((Object)node)) {
                            missingOne = true;
                            continue;
                        }
                        missingAll = false;
                    }
                    this.viewer.setChecked((Object)container, change ? collectInfo.wasChecked : !missingAll);
                    this.viewer.setGrayed((Object)container, missingOne);
                }
                catch (DBException dBException) {}
            }
        });
    }

    private boolean collectChildren(DBRProgressMonitor monitor, DBNNode element, CollectInfo collectInfo, boolean onlyChecked) throws DBException {
        Object[] children;
        boolean isChecked;
        if (monitor.isCanceled()) {
            return false;
        }
        for (ViewerFilter filter : this.filters) {
            if (filter.select((Viewer)this.viewer, (Object)element.getParentNode(), (Object)element)) continue;
            return false;
        }
        boolean bl = isChecked = this.checkedElements.containsKey(element) || element == collectInfo.rootElement;
        if (onlyChecked && !collectInfo.wasChecked && !isChecked) {
            return false;
        }
        if (!onlyChecked || isChecked) {
            for (Class<?> type : this.targetTypes) {
                boolean filterObjects;
                boolean bl2 = filterObjects = !DBNNode.class.isAssignableFrom(type);
                if (filterObjects ? !(element instanceof DBNDatabaseNode) || !type.isInstance(((DBNDatabaseNode)element).getObject()) : !type.isInstance(element)) continue;
                collectInfo.targetChildren.add(element);
                return true;
            }
        }
        if (element instanceof DBNDatabaseNode) {
            ((DBNDatabaseNode)element).initializeNode(monitor, null);
        }
        if (!ArrayUtils.isEmpty((Object[])(children = element.getChildren(monitor)))) {
            boolean foundChild = false;
            for (Object child : children) {
                if (onlyChecked) {
                    if (!this.checkedElements.containsKey(child)) continue;
                    foundChild = true;
                    break;
                }
                try {
                    if (!this.collectChildren(monitor, (DBNNode)child, collectInfo, false)) continue;
                    foundChild = true;
                }
                catch (DBException e) {
                    log.debug((Object)("Error reading child nodes of '" + child.getName() + "'"), (Throwable)e);
                }
            }
            if (foundChild && !collectInfo.targetContainers.contains(element)) {
                collectInfo.targetContainers.add(element);
                if (onlyChecked) {
                    this.checkedElements.put(element, Boolean.TRUE);
                }
            }
            return foundChild;
        }
        return false;
    }

    public void updateCheckStates() {
        if (!this.autoCheckNested) {
            return;
        }
        LinkedHashSet<DBNNode> parentList = new LinkedHashSet<DBNNode>();
        for (Object element : this.viewer.getCheckedElements()) {
            for (DBNNode node = ((DBNNode)element).getParentNode(); node != null; node = node.getParentNode()) {
                parentList.add(node);
                this.viewer.setChecked((Object)node, true);
            }
        }
        this.updateElementsCheck(parentList.toArray(), true, false, false);
    }

    private static class CollectInfo {
        DBNNode rootElement;
        boolean wasChecked;
        final List<DBNNode> targetChildren = new ArrayList<DBNNode>();
        final List<DBNNode> targetContainers = new ArrayList<DBNNode>();

        private CollectInfo() {
        }
    }
}

