/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextFindReplaceTarget;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;

public class StyledTextUtils {
    public static void enableDND(final StyledText control) {
        DropTarget dropTarget = new DropTarget((Control)control, 23);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent e) {
                if (e.detail == 16) {
                    e.detail = 1;
                }
            }

            public void dragOperationChanged(DropTargetEvent e) {
                if (e.detail == 16) {
                    e.detail = 1;
                }
            }

            public void drop(DropTargetEvent e) {
                control.insert((String)e.data);
            }
        });
    }

    public static void fillDefaultStyledTextContextMenu(StyledText text) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> StyledTextUtils.fillDefaultStyledTextContextMenu((IContributionManager)manager, text));
        menuMgr.setRemoveAllWhenShown(true);
        text.setMenu(menuMgr.createContextMenu((Control)text));
        text.addDisposeListener(e -> menuMgr.dispose());
    }

    public static void fillDefaultStyledTextContextMenu(IContributionManager menu, final StyledText text) {
        Point selectionRange = text.getSelectionRange();
        menu.add((IAction)new StyledTextAction("org.eclipse.ui.edit.copy", selectionRange.y > 0, text, 17039369));
        menu.add((IAction)new StyledTextAction("org.eclipse.ui.edit.paste", text.getEditable(), text, 16908297));
        menu.add((IAction)new StyledTextAction("org.eclipse.ui.edit.cut", selectionRange.y > 0, text, 131199));
        menu.add((IAction)new StyledTextAction("org.eclipse.ui.edit.selectAll", true, text, 262209));
        menu.add((IAction)new StyledTextActionEx("org.eclipse.ui.edit.text.toggleWordWrap", 2){

            public boolean isChecked() {
                return text.getWordWrap();
            }

            public void run() {
                text.setWordWrap(!text.getWordWrap());
            }
        });
        StyledTextFindReplaceTarget stFindReplaceTarget = new StyledTextFindReplaceTarget(text);
        menu.add(TextEditorUtils.createFindReplaceAction(text.getShell(), stFindReplaceTarget));
        menu.add((IContributionItem)new GroupMarker("styled_text_additions"));
    }

    public static class StyledTextAction
    extends Action {
        private final StyledText styledText;
        private final int action;

        public StyledTextAction(String actionId, boolean enabled, StyledText styledText, int action) {
            super(ActionUtils.findCommandName((String)actionId));
            this.setActionDefinitionId(actionId);
            this.setEnabled(enabled);
            this.styledText = styledText;
            this.action = action;
        }

        public void run() {
            this.styledText.invokeAction(this.action);
        }
    }

    public static class StyledTextActionEx
    extends Action {
        public StyledTextActionEx(String actionId, int style) {
            super(ActionUtils.findCommandName((String)actionId), style);
            this.setActionDefinitionId(actionId);
        }
    }
}

