/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceTypeDescriptor;
import org.jkiss.dbeaver.registry.ResourceTypeDescriptor;

public class ResourceTypeRegistry {
    private static final Log log = Log.getLog(ResourceTypeRegistry.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.resourceType";
    private final List<ResourceTypeDescriptor> resourceTypeDescriptors = new ArrayList<ResourceTypeDescriptor>();
    private static ResourceTypeRegistry instance = null;

    public static synchronized ResourceTypeRegistry getInstance() {
        if (instance == null) {
            instance = new ResourceTypeRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ResourceTypeRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            this.resourceTypeDescriptors.add(new ResourceTypeDescriptor(ext));
            ++n2;
        }
    }

    public List<ResourceTypeDescriptor> getResourceTypes() {
        return this.resourceTypeDescriptors;
    }

    public DBPResourceTypeDescriptor getResourceType(String typeId) {
        for (ResourceTypeDescriptor td : this.resourceTypeDescriptors) {
            if (!td.getId().equals(typeId)) continue;
            return td;
        }
        return null;
    }

    public ResourceTypeDescriptor getResourceTypeByRootPath(DBPProject project, String path) {
        for (ResourceTypeDescriptor rhd : this.resourceTypeDescriptors) {
            String defaultRoot = rhd.getDefaultRoot(project);
            if (defaultRoot == null || !defaultRoot.equals(path)) continue;
            return rhd;
        }
        return null;
    }
}

