/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.registry.ProductBundleDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class ProductBundleRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.product.bundles";
    private static ProductBundleRegistry instance = null;
    private Map<String, ProductBundleDescriptor> bundles = new LinkedHashMap<String, ProductBundleDescriptor>();

    public static synchronized ProductBundleRegistry getInstance() {
        if (instance == null) {
            instance = new ProductBundleRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ProductBundleRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        OSDescriptor localSystem = DBWorkbench.getPlatform().getLocalSystem();
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            ProductBundleDescriptor bundle;
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("bundle".equals(ext.getName()) && (bundle = new ProductBundleDescriptor(ext)).matchesOS(localSystem)) {
                this.bundles.put(bundle.getId(), bundle);
            }
            ++n2;
        }
    }

    public boolean hasBundle(String id) {
        return this.bundles.containsKey(id);
    }

    public ProductBundleDescriptor getBundle(String id) {
        return this.bundles.get(id);
    }
}

