/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;

final class DBeaverWorkspaces {
    private static final Log log = Log.getLog(DBeaverWorkspaces.class);
    private static final int RECENT_MAX_LENGTH = 10;

    private DBeaverWorkspaces() {
    }

    @NotNull
    static List<String> fetchRecentWorkspaces(@NotNull DBeaverApplication application, @NotNull Location location) {
        String workingFolder;
        ChooseWorkspaceData data = new ChooseWorkspaceData(location.getDefault());
        List<String> backedUpWorkspaces = DBeaverWorkspaces.getBackedUpWorkspaces(application);
        List<String> eclipseWorkspaces = Stream.of(data.getRecentWorkspaces()).filter(Objects::nonNull).toList();
        List<String> workspaces = !backedUpWorkspaces.isEmpty() ? backedUpWorkspaces : eclipseWorkspaces;
        if (!(workspaces = workspaces.stream().distinct().limit(10L).collect(Collectors.toList())).contains(workingFolder = application.getDefaultWorkingFolder().toString())) {
            if (workspaces.size() == 10) {
                workspaces.removeLast();
            }
            workspaces.addFirst(workingFolder);
        }
        if (!eclipseWorkspaces.equals(workspaces)) {
            data.setRecentWorkspaces(workspaces.toArray(new String[10]));
            data.writePersistedData();
        }
        if (!backedUpWorkspaces.equals(workspaces)) {
            DBeaverWorkspaces.saveWorkspacesToBackup(application, workspaces);
        }
        return workspaces;
    }

    static void flushRecentWorkspaces(@NotNull DBeaverApplication application, @NotNull Location location) {
        ChooseWorkspaceData data = new ChooseWorkspaceData(location.getDefault());
        List<String> workspaces = Stream.of(data.getRecentWorkspaces()).filter(Objects::nonNull).toList();
        DBeaverWorkspaces.saveWorkspacesToBackup(application, workspaces);
    }

    @NotNull
    private static List<String> getBackedUpWorkspaces(@NotNull DBeaverApplication application) {
        Path path = application.getWorkspacesFile();
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            return Files.readAllLines(path);
        }
        catch (IOException e) {
            log.debug((Object)"Unable to read backed up workspaces", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static void saveWorkspacesToBackup(@NotNull DBeaverApplication application, @NotNull List<String> workspaces) {
        try {
            Path path = application.getWorkspacesFile();
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            } else if (Files.isDirectory(path, new LinkOption[0])) {
                Files.delete(path);
            }
            Files.write(path, workspaces, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            log.debug((Object)"Unable to save backed up workspaces", (Throwable)e);
        }
    }
}

