/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.workingsets;

import java.net.URL;
import java.util.Collections;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.internal.navigator.workingsets.WorkingSetsContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.framework.Bundle;

public class WorkingSetsLabelProvider
implements ILabelProvider {
    private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
    private Image workingSetImage;

    public Image getImage(Object element) {
        if (element instanceof IWorkingSet) {
            return this.labelProvider.getImage(element);
        }
        if (element == WorkingSetsContentProvider.OTHERS_WORKING_SET) {
            return this.getWorkingSetImage();
        }
        return null;
    }

    private Image getWorkingSetImage() {
        if (this.workingSetImage == null) {
            URL iconUrl = FileLocator.find((Bundle)WorkbenchNavigatorPlugin.getDefault().getBundle(), (IPath)IPath.fromPortableString((String)"icons/full/obj16/otherprojects_workingsets.svg"), Collections.emptyMap());
            this.workingSetImage = ImageDescriptor.createFromURL((URL)iconUrl).createImage();
        }
        return this.workingSetImage;
    }

    public String getText(Object element) {
        if (element instanceof IWorkingSet) {
            return ((IWorkingSet)element).getLabel();
        }
        if (element == WorkingSetsContentProvider.OTHERS_WORKING_SET) {
            return WorkbenchNavigatorMessages.workingSet_others;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.workingSetImage != null) {
            this.workingSetImage.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

