/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProcessListener;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DBRProcessDescriptor {
    private static final Log log = Log.getLog(DBRProcessDescriptor.class);
    private final DBRShellCommand command;
    private ProcessBuilder processBuilder;
    private volatile Process process;
    private volatile int exitValue = -1;
    private DBRProcessListener processListener;

    public DBRProcessDescriptor(DBRShellCommand command) {
        this(command, null);
    }

    public DBRProcessDescriptor(DBRShellCommand command, IVariableResolver variablesResolver) {
        List<String> commandParams;
        this.command = command;
        if (command.getCommandParams() != null) {
            commandParams = command.getCommandParams();
        } else {
            String commandLine = variablesResolver == null ? command.getCommand() : GeneralUtils.replaceVariables(command.getCommand(), variablesResolver);
            commandLine = CommonUtils.notEmpty((String)commandLine);
            commandParams = RuntimeUtils.splitCommandLine(commandLine, !RuntimeUtils.isWindows());
        }
        this.processBuilder = new ProcessBuilder(commandParams);
        if (!CommonUtils.isEmpty((String)command.getWorkingDirectory())) {
            this.processBuilder.directory(new File(command.getWorkingDirectory()));
        }
    }

    public String getName() {
        List<String> command = this.processBuilder.command();
        return command.isEmpty() ? "?" : command.get(0);
    }

    public DBRShellCommand getCommand() {
        return this.command;
    }

    public DBRProcessListener getProcessListener() {
        return this.processListener;
    }

    public void setProcessListener(DBRProcessListener processListener) {
        this.processListener = processListener;
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    public Process getProcess() {
        return this.process;
    }

    public boolean isRunning() {
        Process theProcess = this.process;
        return theProcess != null && theProcess.isAlive();
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public int getUpdatedExitValueCode() {
        try {
            this.exitValue = this.process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            log.debug("Process still executing");
        }
        return this.exitValue;
    }

    public void execute() throws DBException {
        if (this.process != null) {
            throw new DBException("Process " + this.getName() + " already running");
        }
        if (CommonUtils.isEmpty(this.processBuilder.command())) {
            throw new DBException("Empty command specified");
        }
        try {
            this.process = this.processBuilder.start();
        }
        catch (IOException e) {
            throw new DBException("Can't start process", e);
        }
        if (this.processListener != null) {
            this.processListener.onProcessStarted();
        }
        if (this.command.getPauseAfterExecute() > 0) {
            try {
                Thread.sleep(this.command.getPauseAfterExecute());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (this.process != null) {
            DBRProcessDescriptor dBRProcessDescriptor = this;
            synchronized (dBRProcessDescriptor) {
                if (this.process != null) {
                    this.process.destroy();
                }
            }
            try {
                if (this.process != null) {
                    this.exitValue = this.process.waitFor();
                }
            }
            catch (InterruptedException interruptedException) {}
            this.process = null;
            if (this.processListener != null) {
                this.processListener.onProcessTerminated(this.exitValue);
            }
        }
    }

    public int waitFor() {
        return this.doWaitFor(false, Integer.MAX_VALUE);
    }

    public int waitFor(int timeoutMs) {
        return this.doWaitFor(true, timeoutMs);
    }

    private int doWaitFor(boolean useTimeout, int timeoutMs) {
        if (this.process != null) {
            try {
                if (useTimeout) {
                    boolean exited = this.process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
                    if (exited) {
                        this.exitValue = this.process.exitValue();
                    }
                } else {
                    this.exitValue = this.process.waitFor();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.processListener != null) {
            this.processListener.onProcessTerminated(this.exitValue);
        }
        return this.exitValue;
    }

    public String dumpErrors() {
        if (this.process == null) {
            return null;
        }
        StringWriter buf = new StringWriter();
        try {
            InputStream inputStream = this.process.getErrorStream();
            if (inputStream != null) {
                InputStreamReader input = new InputStreamReader(inputStream, GeneralUtils.getDefaultConsoleEncoding());
                IOUtils.copyText((Reader)input, (Writer)buf);
            }
        }
        catch (IOException e) {
            e.printStackTrace(new PrintWriter((Writer)buf, true));
        }
        return buf.toString();
    }

    public String dumpOutput() {
        if (this.process == null) {
            return null;
        }
        StringWriter buf = new StringWriter();
        try {
            InputStream inputStream = this.process.getInputStream();
            if (inputStream != null) {
                InputStreamReader input = new InputStreamReader(inputStream, GeneralUtils.getDefaultConsoleEncoding());
                IOUtils.copyText((Reader)input, (Writer)buf);
            }
        }
        catch (IOException e) {
            e.printStackTrace(new PrintWriter((Writer)buf, true));
        }
        return buf.toString();
    }
}

