/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPCloseableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDNull;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ExecuteBatchImpl
implements DBSDataManipulator.ExecuteBatch {
    private static final Log log = Log.getLog(ExecuteBatchImpl.class);
    protected final DBSAttributeBase[] attributes;
    protected final List<Object[]> values = new ArrayList<Object[]>();
    protected final DBDDataReceiver keysReceiver;
    protected final boolean reuseStatement;

    protected ExecuteBatchImpl(@NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, boolean reuseStatement) {
        this.attributes = attributes;
        this.keysReceiver = keysReceiver;
        this.reuseStatement = reuseStatement;
    }

    @Override
    public void add(@NotNull Object[] attributeValues) throws DBCException {
        if (!ArrayUtils.isEmpty((Object[])this.attributes) && ArrayUtils.isEmpty((Object[])attributeValues)) {
            throw new DBCException("Bad attribute values: " + Arrays.toString(attributeValues));
        }
        this.values.add(attributeValues);
    }

    @Override
    @NotNull
    public DBCStatistics execute(@NotNull DBCSession session, Map<String, Object> options) throws DBCException {
        return this.processBatch(session, null, options);
    }

    @Override
    @NotNull
    public void generatePersistActions(@NotNull DBCSession session, @NotNull List<DBEPersistAction> actions, Map<String, Object> options) throws DBCException {
        this.processBatch(session, actions, options);
    }

    @NotNull
    DBCStatistics processBatch(@NotNull DBCSession session, @Nullable List<DBEPersistAction> actions, Map<String, Object> options) throws DBCException {
        boolean skipBindValues;
        boolean useBatch;
        DBDValueHandler[] handlers = new DBDValueHandler[this.attributes.length];
        int i = 0;
        while (i < this.attributes.length) {
            handlers[i] = this.attributes[i] instanceof DBDAttributeBinding ? ((DBDAttributeBinding)this.attributes[i]).getValueHandler() : DBUtils.findValueHandler(session, (DBSTypedObject)this.attributes[i]);
            ++i;
        }
        boolean bl = useBatch = session.getDataSource().getInfo().supportsBatchUpdates() && this.reuseStatement && !CommonUtils.toBoolean((Object)options.get("data.manipulate.disableBatches"));
        if (this.values.size() <= 1) {
            useBatch = false;
        }
        if (skipBindValues = CommonUtils.toBoolean((Object)options.get("data.manipulate.skipBindValues"))) {
            useBatch = false;
        }
        DBCStatistics statistics = new DBCStatistics();
        DBPCloseableObject statement = null;
        try {
            boolean[] prevNulls = new boolean[this.attributes.length];
            boolean[] nulls = new boolean[this.attributes.length];
            int statementsInBatch = 0;
            int rowIndex = 0;
            while (rowIndex < this.values.size()) {
                boolean reuse;
                Object[] rowValues = this.values.get(rowIndex);
                if (session.getProgressMonitor().isCanceled()) break;
                if (rowIndex > 0) {
                    int cfr_ignored_0 = rowIndex % 100;
                }
                boolean bl2 = reuse = !skipBindValues && this.reuseStatement;
                if (reuse) {
                    int i2 = 0;
                    while (i2 < rowValues.length) {
                        nulls[i2] = DBUtils.isNullValue(rowValues[i2]);
                        ++i2;
                    }
                    if (!Arrays.equals(prevNulls, nulls) && statementsInBatch > 0) {
                        reuse = false;
                    }
                    System.arraycopy(nulls, 0, prevNulls, 0, nulls.length);
                    if (!reuse && statementsInBatch > 0) {
                        if (actions == null) {
                            this.flushBatch(statistics, (DBCStatement)statement);
                        }
                        statement.close();
                        statement = null;
                        statementsInBatch = 0;
                        reuse = true;
                    }
                }
                if (statement == null || !reuse) {
                    statement = this.prepareStatement(session, handlers, rowValues, options);
                    statistics.setQueryText(statement.getQueryString());
                    statistics.addStatementsCount();
                }
                try {
                    if (!skipBindValues) {
                        this.bindStatement(handlers, (DBCStatement)statement, rowValues);
                    }
                    if (actions == null) {
                        if (useBatch) {
                            statement.addToBatch();
                            ++statementsInBatch;
                        } else {
                            long startTime = System.currentTimeMillis();
                            this.executeStatement(statistics, (DBCStatement)statement);
                            statistics.addExecuteTime(System.currentTimeMillis() - startTime);
                            long rowCount = statement.getUpdateRowCount();
                            if (rowCount > 0L) {
                                statistics.addRowsUpdated(rowCount);
                            }
                            if (this.keysReceiver != null) {
                                try {
                                    this.readKeys(statement.getSession(), (DBCStatement)statement, this.keysReceiver);
                                }
                                catch (Exception e) {
                                    log.warn("Error reading auto-generated keys", e);
                                }
                            }
                        }
                    } else {
                        String queryString = this.formatQueryParameters(session, statement.getQueryString(), handlers, rowValues);
                        actions.add(new SQLDatabasePersistAction("Execute statement", queryString));
                    }
                }
                finally {
                    if (!reuse && !useBatch) {
                        statement.close();
                    }
                }
                ++rowIndex;
            }
            if (statementsInBatch > 0) {
                if (actions == null) {
                    this.flushBatch(statistics, (DBCStatement)statement);
                }
                statement.close();
                statement = null;
            }
            this.values.clear();
        }
        finally {
            if (this.reuseStatement && statement != null) {
                statement.close();
            }
            if (!useBatch && !this.values.isEmpty()) {
                this.values.clear();
            }
        }
        return statistics;
    }

    protected int getNextUsedParamIndex(Object[] attributeValues, int paramIndex) {
        ++paramIndex;
        while (paramIndex < attributeValues.length && attributeValues[paramIndex] instanceof DBDNull) {
            ++paramIndex;
        }
        return paramIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    String formatQueryParameters(DBCSession session, String queryString, DBDValueHandler[] handlers, Object[] rowValues) {
        if (handlers.length == 0) {
            return queryString;
        }
        if (CommonUtils.isEmpty((String)queryString)) {
            return queryString;
        }
        int length = queryString.length();
        StringBuilder formatted = new StringBuilder(length * 2);
        int paramIndex = -1;
        int i = 0;
        while (i < length) {
            block12: {
                char c = queryString.charAt(i);
                block0 : switch (c) {
                    case '?': {
                        paramIndex = this.getNextUsedParamIndex(rowValues, paramIndex);
                        if (paramIndex >= handlers.length) {
                            log.error("Parameter index out of range (" + paramIndex + " > " + handlers.length + ")");
                            break block12;
                        } else {
                            String paramValue = SQLUtils.convertValueToSQL(session.getDataSource(), this.attributes[paramIndex], handlers[paramIndex], rowValues[paramIndex], DBDDisplayFormat.NATIVE, false);
                            formatted.append((Object)paramValue);
                        }
                        break block12;
                    }
                    case ':': {
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        formatted.append(c);
                        int k = i + 1;
                        while (k < length) {
                            char c2 = queryString.charAt(k);
                            if (c2 == c && queryString.charAt(k - 1) != '\\') {
                                i = k;
                                c = c2;
                                break block0;
                            }
                            formatted.append(c2);
                            ++k;
                        }
                        break block0;
                    }
                }
                formatted.append(c);
            }
            ++i;
        }
        return formatted.toString();
    }

    void flushBatch(DBCStatistics statistics, DBCStatement statement) throws DBCException {
        long startTime = System.currentTimeMillis();
        long[] updatedRows = statement.executeStatementBatch();
        statistics.addExecuteTime(System.currentTimeMillis() - startTime);
        if (!ArrayUtils.isEmpty((long[])updatedRows)) {
            long[] lArray = updatedRows;
            int n = updatedRows.length;
            int n2 = 0;
            while (n2 < n) {
                long rows = lArray[n2];
                if (rows < 0L && !ArrayUtils.isEmpty((Object[])this.attributes)) {
                    rows = 1L;
                }
                statistics.addRowsUpdated(rows);
                ++n2;
            }
        }
        this.saveExecuteWarnings(statistics, statement);
    }

    protected void executeStatement(DBCStatistics statistics, DBCStatement statement) throws DBCException {
        statement.executeStatement();
        this.saveExecuteWarnings(statistics, statement);
    }

    private void saveExecuteWarnings(DBCStatistics statistics, DBCStatement statement) throws DBCException {
        Throwable[] warnings = statement.getStatementWarnings();
        if (warnings != null) {
            Throwable[] throwableArray = warnings;
            int n = warnings.length;
            int n2 = 0;
            while (n2 < n) {
                Throwable w = throwableArray[n2];
                statistics.addWarning(w);
                ++n2;
            }
        }
    }

    @Override
    public void close() {
    }

    private void readKeys(@NotNull DBCSession session, @NotNull DBCStatement dbStat, @NotNull DBDDataReceiver keysReceiver) throws DBCException {
        DBCResultSet dbResult;
        try {
            dbResult = dbStat.openGeneratedKeysResultSet();
        }
        catch (Throwable e) {
            log.debug("Error obtaining generated keys", e);
            return;
        }
        if (dbResult == null) {
            return;
        }
        try {
            keysReceiver.fetchStart(session, dbResult, -1L, -1L);
            try {
                while (dbResult.nextRow()) {
                    keysReceiver.fetchRow(session, dbResult);
                }
            }
            finally {
                keysReceiver.fetchEnd(session, dbResult);
            }
        }
        finally {
            dbResult.close();
            keysReceiver.close();
        }
    }

    @NotNull
    protected abstract DBCStatement prepareStatement(@NotNull DBCSession var1, DBDValueHandler[] var2, Object[] var3, Map<String, Object> var4) throws DBCException;

    protected abstract void bindStatement(@NotNull DBDValueHandler[] var1, @NotNull DBCStatement var2, Object[] var3) throws DBCException;
}

