/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.Identity;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;
import org.jkiss.code.NotNull;

public class DBeaverAuthAgent
extends AbstractAuthMethod {
    private final Identity identity;

    public DBeaverAuthAgent(@NotNull Identity identity) throws Buffer.BufferException {
        super("publickey");
        this.identity = identity;
    }

    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60) {
            this.sendSignedReq();
        } else {
            super.handle(cmd, buf);
        }
    }

    protected SSHPacket buildReq() throws UserAuthException {
        return this.buildReq(false);
    }

    @NotNull
    private SSHPacket buildReq(boolean signed) throws UserAuthException {
        return this.putPubKey((SSHPacket)super.buildReq().putBoolean(signed));
    }

    @NotNull
    private SSHPacket putPubKey(SSHPacket reqBuf) {
        ((SSHPacket)reqBuf.putString(this.getAlgName())).putBytes(this.identity.getPublicKeyBlob());
        return reqBuf;
    }

    @NotNull
    private SSHPacket putSig(SSHPacket reqBuf) {
        byte[] dataToSign = ((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.params.getTransport().getSessionID())).putBuffer((Buffer)reqBuf)).getCompactData();
        reqBuf.putBytes(this.identity.getSignature(dataToSign, this.getAlgName()));
        return reqBuf;
    }

    private void sendSignedReq() throws UserAuthException, TransportException {
        this.params.getTransport().write(this.putSig(this.buildReq(true)));
    }

    @NotNull
    private String getAlgName() {
        String name = this.identity.getAlgName();
        if ("ssh-rsa".equals(name)) {
            return "rsa-sha2-512";
        }
        return name;
    }
}

