/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CopyRefactoring;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.CopyProjectProcessor;

public class CopyProjectDescriptor
extends RefactoringDescriptor {
    public static final String ID = "org.eclipse.ltk.core.refactoring.copyproject.resource";
    private IPath fSourcePath;
    private String fNewName;
    private IPath fNewLocation;

    public CopyProjectDescriptor() {
        super(ID, null, RefactoringCoreMessages.RenameResourceDescriptor_unnamed_descriptor, null, 6);
    }

    public IPath getSourcePath() {
        return this.fSourcePath;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public IPath getNewLocation() {
        return this.fNewLocation;
    }

    public void setResourcePath(IPath resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException();
        }
        this.fSourcePath = resourcePath;
    }

    public void setProjectToCopy(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        this.setResourcePath(project.getFullPath());
    }

    @Override
    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = wsRoot.findMember(this.fSourcePath);
        if (resource == null || !resource.exists()) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.CopyProjectDescriptor_project_copy_does_not_exist, BasicElementLabels.getPathLabel(this.fSourcePath, false)));
            return null;
        }
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            return new CopyRefactoring(new CopyProjectProcessor(project, this.fNewName, this.fNewLocation));
        }
        return null;
    }

    public void setNewName(String newName) {
        this.fNewName = newName;
    }

    public void setNewLocation(IPath newLocation) {
        this.fNewLocation = newLocation;
    }
}

