/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.eval;

import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.eval.ScriptVariablesContext;

public class ScriptEvaluateEngine {
    private final SQLScriptContext scriptContext;
    private final JexlEngine jexlEngine;
    private final ScriptVariablesContext variablesContext;

    private ScriptEvaluateEngine(SQLScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        this.jexlEngine = new JexlBuilder().cache(100).create();
        this.variablesContext = new ScriptVariablesContext(scriptContext);
    }

    public Object evaluateExpression(String exprString) throws DBException {
        try {
            JexlExpression expression = this.jexlEngine.createExpression(exprString);
            return expression.evaluate((JexlContext)this.variablesContext);
        }
        catch (Exception e) {
            throw new DBException("Error evaluating expression [" + exprString + "]", (Throwable)e);
        }
    }

    public static ScriptEvaluateEngine getEngine(SQLScriptContext scriptContext) {
        ScriptEvaluateEngine engine = (ScriptEvaluateEngine)scriptContext.getData("evalEngine");
        if (engine == null) {
            engine = new ScriptEvaluateEngine(scriptContext);
            scriptContext.setData("evalEngine", engine);
        }
        return engine;
    }
}

