/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class WKTFileReader {
    private File file = null;
    private Reader reader;
    private WKTReader wktReader;
    private int count = 0;
    private int limit = -1;
    private int offset = 0;
    private boolean isStrictParsing = true;

    public WKTFileReader(File file, WKTReader wktReader) {
        this.file = file;
        this.wktReader = wktReader;
    }

    public WKTFileReader(String filename, WKTReader wktReader) {
        this(new File(filename), wktReader);
    }

    public WKTFileReader(Reader reader, WKTReader wktReader) {
        this.reader = reader;
        this.wktReader = wktReader;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setStrictParsing(boolean isStrict) {
        this.isStrictParsing = isStrict;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public List read() throws IOException, ParseException {
        if (this.file != null) {
            this.reader = new FileReader(this.file);
        }
        this.count = 0;
        try {
            List list;
            BufferedReader bufferedReader = new BufferedReader(this.reader);
            try {
                list = this.read(bufferedReader);
            }
            catch (Throwable throwable) {
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            return list;
        }
        finally {
            this.reader.close();
        }
    }

    private List read(BufferedReader bufferedReader) throws IOException, ParseException {
        ArrayList geoms;
        block2: {
            geoms = new ArrayList();
            try {
                this.read(bufferedReader, geoms);
            }
            catch (ParseException ex) {
                if (!this.isStrictParsing && geoms.size() != 0) break block2;
                throw ex;
            }
        }
        return geoms;
    }

    private void read(BufferedReader bufferedReader, List geoms) throws IOException, ParseException {
        while (!this.isAtEndOfFile(bufferedReader) && !this.isAtLimit(geoms)) {
            Geometry g = this.wktReader.read(bufferedReader);
            if (this.count >= this.offset) {
                geoms.add(g);
            }
            ++this.count;
        }
    }

    private boolean isAtLimit(List geoms) {
        if (this.limit < 0) {
            return false;
        }
        return geoms.size() >= this.limit;
    }

    private boolean isAtEndOfFile(BufferedReader bufferedReader) throws IOException {
        int ch;
        do {
            bufferedReader.mark(1);
            ch = bufferedReader.read();
            if (ch >= 0) continue;
            return true;
        } while (Character.isWhitespace(ch));
        bufferedReader.reset();
        return false;
    }
}

