/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.equinox.internal.p2.ui.dialogs.IPreFilterJobProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class DelayedFilterCheckboxTree
extends FilteredTree {
    private static final long FILTER_DELAY = 800L;
    public static final Object ALL_ITEMS_HACK = new Object();
    ToolBar toolBar;
    Display display;
    PatternFilter patternFilter;
    IPreFilterJobProvider jobProvider;
    DeferredQueryContentProvider contentProvider;
    String savedFilterText;
    Job preFilterJob;
    WorkbenchJob filterJob;
    boolean ignoreFiltering = true;
    Object viewerInput;
    HashSet<Object> checkState = new HashSet();
    Set<Object> expanded = new HashSet<Object>();
    ContainerCheckedTreeViewer checkboxViewer;

    public DelayedFilterCheckboxTree(Composite parent, int treeStyle, PatternFilter filter, IPreFilterJobProvider jobProvider) {
        super(parent, true);
        this.display = parent.getDisplay();
        this.patternFilter = filter;
        this.init(treeStyle, filter);
    }

    protected TreeViewer doCreateTreeViewer(Composite composite, int style) {
        this.checkboxViewer = new ContainerCheckedTreeViewer(composite, style);
        this.checkboxViewer.addCheckStateListener(event -> {
            if (!event.getChecked() && this.checkState != null) {
                if (event.getElement() == ALL_ITEMS_HACK) {
                    this.clearCheckStateCache();
                } else {
                    ArrayList<Object> toRemove = new ArrayList<Object>(1);
                    if (this.contentProvider.hasChildren(event.getElement())) {
                        HashSet<Object> unchecked = new HashSet<Object>();
                        this.uncheckAllChildren(unchecked, event.getElement());
                        for (Object current : this.checkState) {
                            if (current == null || !unchecked.contains(current)) continue;
                            toRemove.add(current);
                        }
                    } else {
                        for (Object element2 : this.checkState) {
                            if (!this.checkboxViewer.getComparer().equals(element2, event.getElement())) continue;
                            toRemove.add(element2);
                        }
                    }
                    this.checkState.removeAll(toRemove);
                }
            } else if (event.getChecked()) {
                this.rememberLeafCheckState();
            }
        });
        return this.checkboxViewer;
    }

    private void uncheckAllChildren(Set<Object> unchecked, Object element) {
        Object[] objectArray = this.contentProvider.getChildren(element);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            unchecked.add(child);
            if (this.contentProvider.getChildren(child).length > 0) {
                this.uncheckAllChildren(unchecked, child);
            }
            ++n2;
        }
    }

    protected Composite createFilterControls(Composite filterParent) {
        super.createFilterControls(filterParent);
        filterParent.addDisposeListener(e -> this.cancelPreFilterJob());
        return filterParent;
    }

    public void contentProviderSet(DeferredQueryContentProvider deferredProvider) {
        this.contentProvider = deferredProvider;
        deferredProvider.addListener((v, oldInput, newInput) -> {
            if (newInput == null) {
                return;
            }
            this.viewerInput = newInput;
            this.cancelPreFilterJob();
            this.cancelAndResetFilterJob();
            this.contentProvider.setSynchronous(false);
            this.rememberExpansions();
            this.checkboxViewer.getTree().setRedraw(false);
            this.display.asyncExec(() -> {
                if (this.checkboxViewer.getTree().isDisposed()) {
                    return;
                }
                this.rememberExpansions();
                this.restoreLeafCheckState();
                this.rememberExpansions();
                this.restoreExpansions();
                this.checkboxViewer.getTree().setRedraw(true);
            });
        });
    }

    public void clearCheckStateCache() {
        this.checkState = null;
    }

    private void refresh(boolean[] shouldPreFilter) {
        if (this.filterText != null && !this.filterText.isDisposed()) {
            String text = this.getFilterString();
            if (text == null || this.initialText != null && this.initialText.equals(text)) {
                return;
            }
            if (!this.contentProvider.getSynchronous() && this.preFilterJob == null && this.filterText != null && !this.filterText.isDisposed()) {
                shouldPreFilter[0] = true;
            }
        }
    }

    protected WorkbenchJob doCreateRefreshJob() {
        this.filterJob = super.doCreateRefreshJob();
        this.filterJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                if (!DelayedFilterCheckboxTree.this.ignoreFiltering) {
                    return;
                }
                boolean[] shouldPreFilter = new boolean[]{false};
                DelayedFilterCheckboxTree.this.display.syncExec(() -> DelayedFilterCheckboxTree.this.refresh(shouldPreFilter));
                if (shouldPreFilter[0]) {
                    event.getJob().sleep();
                    DelayedFilterCheckboxTree.this.schedulePreFilterJob();
                } else if (DelayedFilterCheckboxTree.this.ignoreFiltering) {
                    event.getJob().sleep();
                } else {
                    DelayedFilterCheckboxTree.this.rememberLeafCheckState();
                }
            }

            public void running(IJobChangeEvent event) {
                DelayedFilterCheckboxTree.this.display.syncExec(() -> DelayedFilterCheckboxTree.this.rememberLeafCheckState());
            }

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    DelayedFilterCheckboxTree.this.display.asyncExec(() -> {
                        if (DelayedFilterCheckboxTree.this.checkboxViewer.getTree().isDisposed()) {
                            return;
                        }
                        DelayedFilterCheckboxTree.this.checkboxViewer.getTree().setRedraw(false);
                        DelayedFilterCheckboxTree.this.rememberExpansions();
                        DelayedFilterCheckboxTree.this.restoreLeafCheckState();
                        DelayedFilterCheckboxTree.this.restoreExpansions();
                        DelayedFilterCheckboxTree.this.checkboxViewer.getTree().setRedraw(true);
                    });
                }
            }
        });
        return this.filterJob;
    }

    void schedulePreFilterJob() {
        this.cancelPreFilterJob();
        this.ignoreFiltering = false;
        Job job = this.preFilterJob = this.jobProvider == null ? null : this.jobProvider.getPreFilterJob();
        if (this.preFilterJob == null) {
            if (this.filterJob != null) {
                this.filterJob.wakeUp();
            }
            return;
        }
        this.ignoreFiltering = true;
        this.preFilterJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DelayedFilterCheckboxTree.this.ignoreFiltering = false;
                DelayedFilterCheckboxTree.this.contentProvider.setSynchronous(true);
                if (DelayedFilterCheckboxTree.this.filterJob != null) {
                    DelayedFilterCheckboxTree.this.filterJob.wakeUp();
                }
                DelayedFilterCheckboxTree.this.preFilterJob = null;
            }
        });
        this.preFilterJob.setSystem(true);
        this.preFilterJob.setUser(false);
        this.preFilterJob.schedule();
    }

    void cancelPreFilterJob() {
        if (this.preFilterJob != null) {
            this.preFilterJob.cancel();
            this.preFilterJob = null;
        }
    }

    void cancelAndResetFilterJob() {
        if (this.filterJob != null) {
            this.filterJob.cancel();
        }
    }

    void rememberLeafCheckState() {
        ContainerCheckedTreeViewer v = (ContainerCheckedTreeViewer)this.getViewer();
        Object[] checked = v.getCheckedElements();
        if (this.checkState == null) {
            this.checkState = new HashSet(checked.length);
        }
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!v.getGrayed(element) && this.contentProvider.getChildren(element).length == 0 && !this.checkState.contains(element)) {
                this.checkState.add(element);
            }
            ++n2;
        }
    }

    void restoreLeafCheckState() {
        if (this.checkboxViewer == null || this.checkboxViewer.getTree().isDisposed()) {
            return;
        }
        if (this.checkState == null) {
            return;
        }
        this.checkboxViewer.setCheckedElements(new Object[0]);
        this.checkboxViewer.setGrayedElements(new Object[0]);
        Iterator<Object> iter = this.checkState.iterator();
        Object element = null;
        if (iter.hasNext()) {
            this.checkboxViewer.expandAll();
        }
        while (iter.hasNext()) {
            element = iter.next();
            this.checkboxViewer.setChecked(element, true);
        }
        if (element != null) {
            this.checkboxViewer.fireCheckStateChanged(element, true);
        }
    }

    void rememberExpansions() {
        this.expanded.addAll(Arrays.asList(this.getViewer().getExpandedElements()));
    }

    void restoreExpansions() {
        this.getViewer().setExpandedElements(this.expanded.toArray());
    }

    public ContainerCheckedTreeViewer getCheckboxTreeViewer() {
        return this.checkboxViewer;
    }

    protected long getRefreshJobDelay() {
        return 800L;
    }

    public Object[] getCheckedElements() {
        if (this.checkState != null) {
            return this.checkState.toArray();
        }
        return new Object[0];
    }

    protected String getFilterString() {
        return super.getFilterString();
    }
}

