/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.LinearRing;
import org.cugos.wkg.Surface;

public class Polygon
extends Surface {
    private final LinearRing outerLinearRing;
    private final List<LinearRing> innerLinearRings;

    public Polygon(LinearRing outerLinearRing, List<LinearRing> innerLinearRings, Dimension dimension) {
        this(outerLinearRing, innerLinearRings, dimension, null);
    }

    public Polygon(LinearRing outerLinearRing, List<LinearRing> innerLinearRings, Dimension dimension, String srid) {
        super(dimension, srid);
        this.outerLinearRing = outerLinearRing;
        this.innerLinearRings = Collections.unmodifiableList(innerLinearRings);
    }

    public Polygon(LinearRing outerLinearRing, Dimension dimension) {
        this(outerLinearRing, new ArrayList<LinearRing>(), dimension);
    }

    public Polygon(LinearRing outerLinearRing, Dimension dimension, String srid) {
        this(outerLinearRing, new ArrayList<LinearRing>(), dimension, srid);
    }

    public LinearRing getOuterLinearRing() {
        return this.outerLinearRing;
    }

    public List<LinearRing> getInnerLinearRings() {
        return this.innerLinearRings;
    }

    @Override
    public boolean isEmpty() {
        return this.outerLinearRing == null | this.outerLinearRing.isEmpty();
    }

    @Override
    public int getNumberOfCoordinates() {
        int numberOfCoordinates = this.outerLinearRing.getNumberOfCoordinates();
        for (LinearRing linearRing : this.innerLinearRings) {
            numberOfCoordinates += linearRing.getNumberOfCoordinates();
        }
        return numberOfCoordinates;
    }

    @Override
    public List<Coordinate> getCoordinates() {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.addAll(this.outerLinearRing.getCoordinates());
        for (LinearRing linearRing : this.innerLinearRings) {
            coordinates.addAll(linearRing.getCoordinates());
        }
        return Collections.unmodifiableList(coordinates);
    }

    public static Polygon createEmpty() {
        return new Polygon(LinearRing.createEmpty(), new ArrayList<LinearRing>(), Dimension.Two, null);
    }
}

