/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.ui.config;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBPrivilege;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBRelationalUser;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class IoTDBCommandGrantPrivilege
extends DBECommandAbstract<IoTDBRelationalUser> {
    private int operationType;
    private String database;
    private String table;
    private IoTDBPrivilege privilege;

    public IoTDBCommandGrantPrivilege(IoTDBRelationalUser user, int type, String database, String table, IoTDBPrivilege privilege) {
        super((DBPObject)user, "Grant or Revoke Privilege");
        this.operationType = type;
        this.database = database;
        this.table = table;
        this.privilege = privilege;
    }

    @NotNull
    public DBEPersistAction[] getPersistActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull Map<String, Object> options) {
        DBEPersistAction[] dBEPersistActionArray;
        Object operationScript;
        String privilegeName = this.privilege.getName().toUpperCase();
        Object grantScript = "";
        Object revokeScript = "";
        if (this.database.isEmpty() || this.table.isEmpty()) {
            grantScript = "GRANT " + privilegeName + " TO USER " + ((IoTDBRelationalUser)this.getObject()).getName();
            revokeScript = "REVOKE " + privilegeName + " FROM USER " + ((IoTDBRelationalUser)this.getObject()).getName();
        } else {
            int scopeType = 0;
            if (this.database.equals("(ALL)")) {
                scopeType = 2;
            } else if (this.table.equals("(ALL)")) {
                scopeType = 1;
            }
            Object scope = scopeType == 0 ? this.database + "." + this.table : (scopeType == 1 ? "DATABASE " + this.database : "ANY");
            grantScript = "GRANT " + privilegeName + " ON " + (String)scope + " TO USER " + ((IoTDBRelationalUser)this.getObject()).getName();
            revokeScript = "REVOKE " + privilegeName + " ON " + (String)scope + " FROM USER " + ((IoTDBRelationalUser)this.getObject()).getName();
        }
        switch (this.operationType) {
            case 0: {
                Object object = revokeScript;
                break;
            }
            case 1: {
                Object object = grantScript;
                break;
            }
            case 2: {
                Object object = (String)grantScript + " WITH GRANT OPTION";
                break;
            }
            case 3: {
                Object object = revokeScript;
                break;
            }
            default: {
                Object object = operationScript = "";
            }
        }
        if (this.operationType == 0) {
            DBEPersistAction[] dBEPersistActionArray2 = new DBEPersistAction[2];
            dBEPersistActionArray2[0] = new SQLDatabasePersistAction("Grant or Revoke Privilege", (String)operationScript);
            dBEPersistActionArray = dBEPersistActionArray2;
            dBEPersistActionArray2[1] = new SQLDatabasePersistAction("Grant or Revoke Privilege", (String)grantScript);
        } else {
            DBEPersistAction[] dBEPersistActionArray3 = new DBEPersistAction[1];
            dBEPersistActionArray = dBEPersistActionArray3;
            dBEPersistActionArray3[0] = new SQLDatabasePersistAction("Grant or Revoke Privilege", (String)operationScript);
        }
        return dBEPersistActionArray;
    }
}

