﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {

/**
 * <p>Specifies geographic information about an endpoint.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointLocation">AWS
 * API Reference</a></p>
 */
class EndpointLocation {
 public:
  AWS_PINPOINT_API EndpointLocation() = default;
  AWS_PINPOINT_API EndpointLocation(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API EndpointLocation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the city where the endpoint is located.</p>
   */
  inline const Aws::String& GetCity() const { return m_city; }
  inline bool CityHasBeenSet() const { return m_cityHasBeenSet; }
  template <typename CityT = Aws::String>
  void SetCity(CityT&& value) {
    m_cityHasBeenSet = true;
    m_city = std::forward<CityT>(value);
  }
  template <typename CityT = Aws::String>
  EndpointLocation& WithCity(CityT&& value) {
    SetCity(std::forward<CityT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or
   * region where the endpoint is located. For example, US for the United States.</p>
   */
  inline const Aws::String& GetCountry() const { return m_country; }
  inline bool CountryHasBeenSet() const { return m_countryHasBeenSet; }
  template <typename CountryT = Aws::String>
  void SetCountry(CountryT&& value) {
    m_countryHasBeenSet = true;
    m_country = std::forward<CountryT>(value);
  }
  template <typename CountryT = Aws::String>
  EndpointLocation& WithCountry(CountryT&& value) {
    SetCountry(std::forward<CountryT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The latitude coordinate of the endpoint location, rounded to one decimal
   * place.</p>
   */
  inline double GetLatitude() const { return m_latitude; }
  inline bool LatitudeHasBeenSet() const { return m_latitudeHasBeenSet; }
  inline void SetLatitude(double value) {
    m_latitudeHasBeenSet = true;
    m_latitude = value;
  }
  inline EndpointLocation& WithLatitude(double value) {
    SetLatitude(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The longitude coordinate of the endpoint location, rounded to one decimal
   * place.</p>
   */
  inline double GetLongitude() const { return m_longitude; }
  inline bool LongitudeHasBeenSet() const { return m_longitudeHasBeenSet; }
  inline void SetLongitude(double value) {
    m_longitudeHasBeenSet = true;
    m_longitude = value;
  }
  inline EndpointLocation& WithLongitude(double value) {
    SetLongitude(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The postal or ZIP code for the area where the endpoint is located.</p>
   */
  inline const Aws::String& GetPostalCode() const { return m_postalCode; }
  inline bool PostalCodeHasBeenSet() const { return m_postalCodeHasBeenSet; }
  template <typename PostalCodeT = Aws::String>
  void SetPostalCode(PostalCodeT&& value) {
    m_postalCodeHasBeenSet = true;
    m_postalCode = std::forward<PostalCodeT>(value);
  }
  template <typename PostalCodeT = Aws::String>
  EndpointLocation& WithPostalCode(PostalCodeT&& value) {
    SetPostalCode(std::forward<PostalCodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the region where the endpoint is located. For locations in the
   * United States, this value is the name of a state.</p>
   */
  inline const Aws::String& GetRegion() const { return m_region; }
  inline bool RegionHasBeenSet() const { return m_regionHasBeenSet; }
  template <typename RegionT = Aws::String>
  void SetRegion(RegionT&& value) {
    m_regionHasBeenSet = true;
    m_region = std::forward<RegionT>(value);
  }
  template <typename RegionT = Aws::String>
  EndpointLocation& WithRegion(RegionT&& value) {
    SetRegion(std::forward<RegionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_city;

  Aws::String m_country;

  double m_latitude{0.0};

  double m_longitude{0.0};

  Aws::String m_postalCode;

  Aws::String m_region;
  bool m_cityHasBeenSet = false;
  bool m_countryHasBeenSet = false;
  bool m_latitudeHasBeenSet = false;
  bool m_longitudeHasBeenSet = false;
  bool m_postalCodeHasBeenSet = false;
  bool m_regionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
