﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/notifications/Notifications_EXPORTS.h>
#include <aws/notifications/model/MemberAccount.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Notifications {
namespace Model {
class ListMemberAccountsResult {
 public:
  AWS_NOTIFICATIONS_API ListMemberAccountsResult() = default;
  AWS_NOTIFICATIONS_API ListMemberAccountsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_NOTIFICATIONS_API ListMemberAccountsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of member accounts that match the specified criteria.</p>
   */
  inline const Aws::Vector<MemberAccount>& GetMemberAccounts() const { return m_memberAccounts; }
  template <typename MemberAccountsT = Aws::Vector<MemberAccount>>
  void SetMemberAccounts(MemberAccountsT&& value) {
    m_memberAccountsHasBeenSet = true;
    m_memberAccounts = std::forward<MemberAccountsT>(value);
  }
  template <typename MemberAccountsT = Aws::Vector<MemberAccount>>
  ListMemberAccountsResult& WithMemberAccounts(MemberAccountsT&& value) {
    SetMemberAccounts(std::forward<MemberAccountsT>(value));
    return *this;
  }
  template <typename MemberAccountsT = MemberAccount>
  ListMemberAccountsResult& AddMemberAccounts(MemberAccountsT&& value) {
    m_memberAccountsHasBeenSet = true;
    m_memberAccounts.emplace_back(std::forward<MemberAccountsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use for the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListMemberAccountsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListMemberAccountsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<MemberAccount> m_memberAccounts;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_memberAccountsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Notifications
}  // namespace Aws
