﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/GuardDutyRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/model/MalwareProtectionPlanActions.h>
#include <aws/guardduty/model/UpdateProtectedResource.h>
#include <utility>

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

  /**
   */
  class UpdateMalwareProtectionPlanRequest : public GuardDutyRequest
  {
  public:
    AWS_GUARDDUTY_API UpdateMalwareProtectionPlanRequest() = default;

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "UpdateMalwareProtectionPlan"; }

    AWS_GUARDDUTY_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>A unique identifier associated with the Malware Protection plan.</p>
     */
    inline const Aws::String& GetMalwareProtectionPlanId() const { return m_malwareProtectionPlanId; }
    inline bool MalwareProtectionPlanIdHasBeenSet() const { return m_malwareProtectionPlanIdHasBeenSet; }
    template<typename MalwareProtectionPlanIdT = Aws::String>
    void SetMalwareProtectionPlanId(MalwareProtectionPlanIdT&& value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId = std::forward<MalwareProtectionPlanIdT>(value); }
    template<typename MalwareProtectionPlanIdT = Aws::String>
    UpdateMalwareProtectionPlanRequest& WithMalwareProtectionPlanId(MalwareProtectionPlanIdT&& value) { SetMalwareProtectionPlanId(std::forward<MalwareProtectionPlanIdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Amazon Resource Name (ARN) of the IAM role with permissions to scan and add
     * tags to the associated protected resource.</p>
     */
    inline const Aws::String& GetRole() const { return m_role; }
    inline bool RoleHasBeenSet() const { return m_roleHasBeenSet; }
    template<typename RoleT = Aws::String>
    void SetRole(RoleT&& value) { m_roleHasBeenSet = true; m_role = std::forward<RoleT>(value); }
    template<typename RoleT = Aws::String>
    UpdateMalwareProtectionPlanRequest& WithRole(RoleT&& value) { SetRole(std::forward<RoleT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about whether the tags will be added to the S3 object after
     * scanning.</p>
     */
    inline const MalwareProtectionPlanActions& GetActions() const { return m_actions; }
    inline bool ActionsHasBeenSet() const { return m_actionsHasBeenSet; }
    template<typename ActionsT = MalwareProtectionPlanActions>
    void SetActions(ActionsT&& value) { m_actionsHasBeenSet = true; m_actions = std::forward<ActionsT>(value); }
    template<typename ActionsT = MalwareProtectionPlanActions>
    UpdateMalwareProtectionPlanRequest& WithActions(ActionsT&& value) { SetActions(std::forward<ActionsT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the protected resource that is associated with the created
     * Malware Protection plan. Presently, <code>S3Bucket</code> is the only supported
     * protected resource.</p>
     */
    inline const UpdateProtectedResource& GetProtectedResource() const { return m_protectedResource; }
    inline bool ProtectedResourceHasBeenSet() const { return m_protectedResourceHasBeenSet; }
    template<typename ProtectedResourceT = UpdateProtectedResource>
    void SetProtectedResource(ProtectedResourceT&& value) { m_protectedResourceHasBeenSet = true; m_protectedResource = std::forward<ProtectedResourceT>(value); }
    template<typename ProtectedResourceT = UpdateProtectedResource>
    UpdateMalwareProtectionPlanRequest& WithProtectedResource(ProtectedResourceT&& value) { SetProtectedResource(std::forward<ProtectedResourceT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_malwareProtectionPlanId;
    bool m_malwareProtectionPlanIdHasBeenSet = false;

    Aws::String m_role;
    bool m_roleHasBeenSet = false;

    MalwareProtectionPlanActions m_actions;
    bool m_actionsHasBeenSet = false;

    UpdateProtectedResource m_protectedResource;
    bool m_protectedResourceHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
