﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/detective/Detective_EXPORTS.h>
#include <aws/detective/model/TTPsObservedDetail.h>
#include <aws/detective/model/ImpossibleTravelDetail.h>
#include <aws/detective/model/FlaggedIpAddressDetail.h>
#include <aws/detective/model/NewGeolocationDetail.h>
#include <aws/detective/model/NewAsoDetail.h>
#include <aws/detective/model/NewUserAgentDetail.h>
#include <aws/detective/model/RelatedFindingDetail.h>
#include <aws/detective/model/RelatedFindingGroupDetail.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Detective
{
namespace Model
{

  /**
   * <p>Details about the indicators of compromise which are used to determine if a
   * resource is involved in a security incident. An indicator of compromise (IOC) is
   * an artifact observed in or on a network, system, or environment that can (with a
   * high level of confidence) identify malicious activity or a security incident.
   * For the list of indicators of compromise that are generated by Detective
   * investigations, see <a
   * href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html">Detective
   * investigations</a>.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/IndicatorDetail">AWS
   * API Reference</a></p>
   */
  class IndicatorDetail
  {
  public:
    AWS_DETECTIVE_API IndicatorDetail() = default;
    AWS_DETECTIVE_API IndicatorDetail(Aws::Utils::Json::JsonView jsonValue);
    AWS_DETECTIVE_API IndicatorDetail& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_DETECTIVE_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Details about the indicator of compromise.</p>
     */
    inline const TTPsObservedDetail& GetTTPsObservedDetail() const { return m_tTPsObservedDetail; }
    inline bool TTPsObservedDetailHasBeenSet() const { return m_tTPsObservedDetailHasBeenSet; }
    template<typename TTPsObservedDetailT = TTPsObservedDetail>
    void SetTTPsObservedDetail(TTPsObservedDetailT&& value) { m_tTPsObservedDetailHasBeenSet = true; m_tTPsObservedDetail = std::forward<TTPsObservedDetailT>(value); }
    template<typename TTPsObservedDetailT = TTPsObservedDetail>
    IndicatorDetail& WithTTPsObservedDetail(TTPsObservedDetailT&& value) { SetTTPsObservedDetail(std::forward<TTPsObservedDetailT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Identifies unusual and impossible user activity for an account. </p>
     */
    inline const ImpossibleTravelDetail& GetImpossibleTravelDetail() const { return m_impossibleTravelDetail; }
    inline bool ImpossibleTravelDetailHasBeenSet() const { return m_impossibleTravelDetailHasBeenSet; }
    template<typename ImpossibleTravelDetailT = ImpossibleTravelDetail>
    void SetImpossibleTravelDetail(ImpossibleTravelDetailT&& value) { m_impossibleTravelDetailHasBeenSet = true; m_impossibleTravelDetail = std::forward<ImpossibleTravelDetailT>(value); }
    template<typename ImpossibleTravelDetailT = ImpossibleTravelDetail>
    IndicatorDetail& WithImpossibleTravelDetail(ImpossibleTravelDetailT&& value) { SetImpossibleTravelDetail(std::forward<ImpossibleTravelDetailT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Suspicious IP addresses that are flagged, which indicates critical or severe
     * threats based on threat intelligence by Detective. This indicator is derived
     * from Amazon Web Services threat intelligence.</p>
     */
    inline const FlaggedIpAddressDetail& GetFlaggedIpAddressDetail() const { return m_flaggedIpAddressDetail; }
    inline bool FlaggedIpAddressDetailHasBeenSet() const { return m_flaggedIpAddressDetailHasBeenSet; }
    template<typename FlaggedIpAddressDetailT = FlaggedIpAddressDetail>
    void SetFlaggedIpAddressDetail(FlaggedIpAddressDetailT&& value) { m_flaggedIpAddressDetailHasBeenSet = true; m_flaggedIpAddressDetail = std::forward<FlaggedIpAddressDetailT>(value); }
    template<typename FlaggedIpAddressDetailT = FlaggedIpAddressDetail>
    IndicatorDetail& WithFlaggedIpAddressDetail(FlaggedIpAddressDetailT&& value) { SetFlaggedIpAddressDetail(std::forward<FlaggedIpAddressDetailT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains details about the new geographic location.</p>
     */
    inline const NewGeolocationDetail& GetNewGeolocationDetail() const { return m_newGeolocationDetail; }
    inline bool NewGeolocationDetailHasBeenSet() const { return m_newGeolocationDetailHasBeenSet; }
    template<typename NewGeolocationDetailT = NewGeolocationDetail>
    void SetNewGeolocationDetail(NewGeolocationDetailT&& value) { m_newGeolocationDetailHasBeenSet = true; m_newGeolocationDetail = std::forward<NewGeolocationDetailT>(value); }
    template<typename NewGeolocationDetailT = NewGeolocationDetail>
    IndicatorDetail& WithNewGeolocationDetail(NewGeolocationDetailT&& value) { SetNewGeolocationDetail(std::forward<NewGeolocationDetailT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains details about the new Autonomous System Organization (ASO).</p>
     */
    inline const NewAsoDetail& GetNewAsoDetail() const { return m_newAsoDetail; }
    inline bool NewAsoDetailHasBeenSet() const { return m_newAsoDetailHasBeenSet; }
    template<typename NewAsoDetailT = NewAsoDetail>
    void SetNewAsoDetail(NewAsoDetailT&& value) { m_newAsoDetailHasBeenSet = true; m_newAsoDetail = std::forward<NewAsoDetailT>(value); }
    template<typename NewAsoDetailT = NewAsoDetail>
    IndicatorDetail& WithNewAsoDetail(NewAsoDetailT&& value) { SetNewAsoDetail(std::forward<NewAsoDetailT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains details about the new user agent.</p>
     */
    inline const NewUserAgentDetail& GetNewUserAgentDetail() const { return m_newUserAgentDetail; }
    inline bool NewUserAgentDetailHasBeenSet() const { return m_newUserAgentDetailHasBeenSet; }
    template<typename NewUserAgentDetailT = NewUserAgentDetail>
    void SetNewUserAgentDetail(NewUserAgentDetailT&& value) { m_newUserAgentDetailHasBeenSet = true; m_newUserAgentDetail = std::forward<NewUserAgentDetailT>(value); }
    template<typename NewUserAgentDetailT = NewUserAgentDetail>
    IndicatorDetail& WithNewUserAgentDetail(NewUserAgentDetailT&& value) { SetNewUserAgentDetail(std::forward<NewUserAgentDetailT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains details about related findings.</p>
     */
    inline const RelatedFindingDetail& GetRelatedFindingDetail() const { return m_relatedFindingDetail; }
    inline bool RelatedFindingDetailHasBeenSet() const { return m_relatedFindingDetailHasBeenSet; }
    template<typename RelatedFindingDetailT = RelatedFindingDetail>
    void SetRelatedFindingDetail(RelatedFindingDetailT&& value) { m_relatedFindingDetailHasBeenSet = true; m_relatedFindingDetail = std::forward<RelatedFindingDetailT>(value); }
    template<typename RelatedFindingDetailT = RelatedFindingDetail>
    IndicatorDetail& WithRelatedFindingDetail(RelatedFindingDetailT&& value) { SetRelatedFindingDetail(std::forward<RelatedFindingDetailT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains details about related finding groups.</p>
     */
    inline const RelatedFindingGroupDetail& GetRelatedFindingGroupDetail() const { return m_relatedFindingGroupDetail; }
    inline bool RelatedFindingGroupDetailHasBeenSet() const { return m_relatedFindingGroupDetailHasBeenSet; }
    template<typename RelatedFindingGroupDetailT = RelatedFindingGroupDetail>
    void SetRelatedFindingGroupDetail(RelatedFindingGroupDetailT&& value) { m_relatedFindingGroupDetailHasBeenSet = true; m_relatedFindingGroupDetail = std::forward<RelatedFindingGroupDetailT>(value); }
    template<typename RelatedFindingGroupDetailT = RelatedFindingGroupDetail>
    IndicatorDetail& WithRelatedFindingGroupDetail(RelatedFindingGroupDetailT&& value) { SetRelatedFindingGroupDetail(std::forward<RelatedFindingGroupDetailT>(value)); return *this;}
    ///@}
  private:

    TTPsObservedDetail m_tTPsObservedDetail;
    bool m_tTPsObservedDetailHasBeenSet = false;

    ImpossibleTravelDetail m_impossibleTravelDetail;
    bool m_impossibleTravelDetailHasBeenSet = false;

    FlaggedIpAddressDetail m_flaggedIpAddressDetail;
    bool m_flaggedIpAddressDetailHasBeenSet = false;

    NewGeolocationDetail m_newGeolocationDetail;
    bool m_newGeolocationDetailHasBeenSet = false;

    NewAsoDetail m_newAsoDetail;
    bool m_newAsoDetailHasBeenSet = false;

    NewUserAgentDetail m_newUserAgentDetail;
    bool m_newUserAgentDetailHasBeenSet = false;

    RelatedFindingDetail m_relatedFindingDetail;
    bool m_relatedFindingDetailHasBeenSet = false;

    RelatedFindingGroupDetail m_relatedFindingGroupDetail;
    bool m_relatedFindingGroupDetailHasBeenSet = false;
  };

} // namespace Model
} // namespace Detective
} // namespace Aws
