﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock/Bedrock_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace Bedrock
{
namespace Model
{
  enum class InferenceProfileStatus
  {
    NOT_SET,
    ACTIVE
  };

namespace InferenceProfileStatusMapper
{
AWS_BEDROCK_API InferenceProfileStatus GetInferenceProfileStatusForName(const Aws::String& name);

AWS_BEDROCK_API Aws::String GetNameForInferenceProfileStatus(InferenceProfileStatus value);
} // namespace InferenceProfileStatusMapper
} // namespace Model
} // namespace Bedrock
} // namespace Aws
