/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import jakarta.servlet.http.WebConnection;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.coyote.ProtocolException;
import org.apache.coyote.http2.ByteUtil;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Flags;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.HpackDecoder;
import org.apache.coyote.http2.HpackException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Setting;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteBufferUtils;
import org.apache.tomcat.util.http.parser.Priority;
import org.apache.tomcat.util.res.StringManager;

class Http2Parser {
    protected static final Log log = LogFactory.getLog(Http2Parser.class);
    protected static final StringManager sm = StringManager.getManager(Http2Parser.class);
    static final byte[] CLIENT_PREFACE_START = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1);
    protected final String connectionId;
    protected final Input input;
    private final Output output;
    private final byte[] frameHeaderBuffer = new byte[9];
    private volatile HpackDecoder hpackDecoder;
    private volatile ByteBuffer headerReadBuffer = ByteBuffer.allocate(1024);
    private volatile int headersCurrentStream = -1;
    private volatile boolean headersEndStream = false;

    Http2Parser(String string, Input input, Output output) {
        this.connectionId = string;
        this.input = input;
        this.output = output;
    }

    @Deprecated
    boolean readFrame(boolean bl) throws Http2Exception, IOException {
        return this.readFrame(bl, null);
    }

    boolean readFrame() throws Http2Exception, IOException {
        return this.readFrame(false, null);
    }

    protected boolean readFrame(boolean bl, FrameType frameType) throws IOException, Http2Exception {
        if (!this.input.fill(bl, this.frameHeaderBuffer)) {
            return false;
        }
        int n = ByteUtil.getThreeBytes(this.frameHeaderBuffer, 0);
        int n2 = ByteUtil.getOneByte(this.frameHeaderBuffer, 3);
        FrameType frameType2 = FrameType.valueOf(n2);
        int n3 = ByteUtil.getOneByte(this.frameHeaderBuffer, 4);
        int n4 = ByteUtil.get31Bits(this.frameHeaderBuffer, 5);
        try {
            this.validateFrame(frameType, frameType2, n4, n3, n);
        }
        catch (StreamException streamException) {
            this.swallowPayload(n4, n2, n, false, null);
            throw streamException;
        }
        switch (frameType2) {
            case DATA: {
                this.readDataFrame(n4, n3, n, null);
                break;
            }
            case HEADERS: {
                this.readHeadersFrame(n4, n3, n, null);
                break;
            }
            case PRIORITY: {
                this.readPriorityFrame(n4, null);
                break;
            }
            case RST: {
                this.readRstFrame(n4, null);
                break;
            }
            case SETTINGS: {
                this.readSettingsFrame(n3, n, null);
                break;
            }
            case PUSH_PROMISE: {
                this.readPushPromiseFrame(n4, n3, n, null);
                break;
            }
            case PING: {
                this.readPingFrame(n3, null);
                break;
            }
            case GOAWAY: {
                this.readGoawayFrame(n, null);
                break;
            }
            case WINDOW_UPDATE: {
                this.readWindowUpdateFrame(n4, null);
                break;
            }
            case CONTINUATION: {
                this.readContinuationFrame(n4, n3, n, null);
                break;
            }
            case PRIORITY_UPDATE: {
                this.readPriorityUpdateFrame(n, null);
                break;
            }
            case UNKNOWN: {
                this.readUnknownFrame(n4, n2, n3, n, null);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readDataFrame(int n, int n2, int n3, ByteBuffer byteBuffer) throws Http2Exception, IOException {
        int n4;
        Object object;
        int n5 = 0;
        boolean bl = Flags.isEndOfStream(n2);
        if (Flags.hasPadding(n2)) {
            if (byteBuffer == null) {
                object = new byte[1];
                this.input.fill(true, (byte[])object);
                n5 = object[0] & 0xFF;
            } else {
                n5 = byteBuffer.get() & 0xFF;
            }
            if (n5 >= n3) {
                throw new ConnectionException(sm.getString("http2Parser.processFrame.tooMuchPadding", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n5), Integer.toString(n3)}), Http2Error.PROTOCOL_ERROR);
            }
            n4 = n3 - (n5 + 1);
        } else {
            n4 = n3;
        }
        if (log.isTraceEnabled()) {
            object = Flags.hasPadding(n2) ? (Object)Integer.toString(n5) : (Object)"none";
            log.trace((Object)sm.getString("http2Parser.processFrameData.lengths", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n4), object}));
        }
        if ((object = (Object)this.output.startRequestBodyFrame(n, n4, bl)) == null) {
            this.swallowPayload(n, FrameType.DATA.getId(), n4, false, byteBuffer);
            if (Flags.hasPadding(n2)) {
                this.swallowPayload(n, FrameType.DATA.getId(), n5, true, byteBuffer);
            }
            if (bl) {
                this.output.receivedEndOfStream(n);
            }
        } else {
            Object object2 = object;
            synchronized (object2) {
                if (((Buffer)object).remaining() < n4) {
                    this.swallowPayload(n, FrameType.DATA.getId(), n4, false, byteBuffer);
                    if (Flags.hasPadding(n2)) {
                        this.swallowPayload(n, FrameType.DATA.getId(), n5, true, byteBuffer);
                    }
                    throw new StreamException(sm.getString("http2Parser.processFrameData.window", new Object[]{this.connectionId}), Http2Error.FLOW_CONTROL_ERROR, n);
                }
                if (byteBuffer == null) {
                    this.input.fill(true, (ByteBuffer)object, n4);
                } else {
                    int n6 = byteBuffer.limit();
                    byteBuffer.limit(byteBuffer.position() + n4);
                    ((ByteBuffer)object).put(byteBuffer);
                    byteBuffer.limit(n6);
                }
                if (Flags.hasPadding(n2)) {
                    this.swallowPayload(n, FrameType.DATA.getId(), n5, true, byteBuffer);
                }
                if (bl) {
                    this.output.receivedEndOfStream(n);
                }
                this.output.endRequestBodyFrame(n, n4);
            }
        }
    }

    protected void readHeadersFrame(int n, int n2, int n3, ByteBuffer byteBuffer) throws Http2Exception, IOException {
        this.headersEndStream = Flags.isEndOfStream(n2);
        if (this.hpackDecoder == null) {
            this.hpackDecoder = this.output.getHpackDecoder();
        }
        try {
            this.hpackDecoder.setHeaderEmitter(this.output.headersStart(n, this.headersEndStream));
        }
        catch (StreamException streamException) {
            this.swallowPayload(n, FrameType.HEADERS.getId(), n3, false, byteBuffer);
            throw streamException;
        }
        int n4 = 0;
        boolean bl = Flags.hasPadding(n2);
        boolean bl2 = Flags.hasPriority(n2);
        int n5 = 0;
        if (bl) {
            n5 = 1;
        }
        if (bl2) {
            n5 += 5;
        }
        if (n5 > 0) {
            byte[] byArray = new byte[n5];
            if (byteBuffer == null) {
                this.input.fill(true, byArray);
            } else {
                byteBuffer.get(byArray);
            }
            if (bl && (n4 = ByteUtil.getOneByte(byArray, 0)) >= n3) {
                throw new ConnectionException(sm.getString("http2Parser.processFrame.tooMuchPadding", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n4), Integer.toString(n3)}), Http2Error.PROTOCOL_ERROR);
            }
            n3 -= n5;
            n3 -= n4;
        }
        this.readHeaderPayload(n, n3, byteBuffer);
        this.swallowPayload(n, FrameType.HEADERS.getId(), n4, true, byteBuffer);
        this.hpackDecoder.getHeaderEmitter().validateHeaders();
        if (Flags.isEndOfHeaders(n2)) {
            this.onHeadersComplete(n);
        } else {
            this.headersCurrentStream = n;
        }
    }

    protected void readPriorityFrame(int n, ByteBuffer byteBuffer) throws IOException {
        try {
            this.swallowPayload(n, FrameType.PRIORITY.getId(), 5, false, byteBuffer);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        this.output.increaseOverheadCount(FrameType.PRIORITY);
    }

    protected void readRstFrame(int n, ByteBuffer byteBuffer) throws Http2Exception, IOException {
        byte[] byArray = new byte[4];
        if (byteBuffer == null) {
            this.input.fill(true, byArray);
        } else {
            byteBuffer.get(byArray);
        }
        long l = ByteUtil.getFourBytes(byArray, 0);
        this.output.reset(n, l);
        this.headersCurrentStream = -1;
        this.headersEndStream = false;
    }

    protected void readSettingsFrame(int n, int n2, ByteBuffer byteBuffer) throws Http2Exception, IOException {
        boolean bl = Flags.isAck(n);
        if (n2 > 0 && bl) {
            throw new ConnectionException(sm.getString("http2Parser.processFrameSettings.ackWithNonZeroPayload"), Http2Error.FRAME_SIZE_ERROR);
        }
        if (n2 == 0 && !bl) {
            this.output.setting(null, 0L);
        } else {
            byte[] byArray = new byte[6];
            for (int i = 0; i < n2 / 6; ++i) {
                if (byteBuffer == null) {
                    this.input.fill(true, byArray);
                } else {
                    byteBuffer.get(byArray);
                }
                int n3 = ByteUtil.getTwoBytes(byArray, 0);
                long l = ByteUtil.getFourBytes(byArray, 2);
                Setting setting = Setting.valueOf(n3);
                if (setting == Setting.UNKNOWN) {
                    log.warn((Object)sm.getString("connectionSettings.unknown", new Object[]{this.connectionId, Integer.toString(n3), Long.toString(l)}));
                }
                this.output.setting(setting, l);
            }
        }
        this.output.settingsEnd(bl);
    }

    protected void readPushPromiseFrame(int n, int n2, int n3, ByteBuffer byteBuffer) throws Http2Exception, IOException {
        throw new ConnectionException(sm.getString("http2Parser.processFramePushPromise", new Object[]{this.connectionId, n}), Http2Error.PROTOCOL_ERROR);
    }

    protected void readPingFrame(int n, ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[8];
        if (byteBuffer == null) {
            this.input.fill(true, byArray);
        } else {
            byteBuffer.get(byArray);
        }
        this.output.pingReceive(byArray, Flags.isAck(n));
    }

    protected void readGoawayFrame(int n, ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[n];
        if (byteBuffer == null) {
            this.input.fill(true, byArray);
        } else {
            byteBuffer.get(byArray);
        }
        int n2 = ByteUtil.get31Bits(byArray, 0);
        long l = ByteUtil.getFourBytes(byArray, 4);
        String string = null;
        if (n > 8) {
            string = new String(byArray, 8, n - 8, StandardCharsets.UTF_8);
        }
        this.output.goaway(n2, l, string);
    }

    protected void readWindowUpdateFrame(int n, ByteBuffer byteBuffer) throws Http2Exception, IOException {
        byte[] byArray = new byte[4];
        if (byteBuffer == null) {
            this.input.fill(true, byArray);
        } else {
            byteBuffer.get(byArray);
        }
        int n2 = ByteUtil.get31Bits(byArray, 0);
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("http2Parser.processFrameWindowUpdate.debug", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n2)}));
        }
        if (n2 == 0) {
            if (n == 0) {
                throw new ConnectionException(sm.getString("http2Parser.processFrameWindowUpdate.invalidIncrement", new Object[]{this.connectionId, Integer.toString(n)}), Http2Error.PROTOCOL_ERROR);
            }
            throw new StreamException(sm.getString("http2Parser.processFrameWindowUpdate.invalidIncrement", new Object[]{this.connectionId, Integer.toString(n)}), Http2Error.PROTOCOL_ERROR, n);
        }
        this.output.incrementWindowSize(n, n2);
    }

    protected void readContinuationFrame(int n, int n2, int n3, ByteBuffer byteBuffer) throws Http2Exception, IOException {
        if (this.headersCurrentStream == -1) {
            throw new ConnectionException(sm.getString("http2Parser.processFrameContinuation.notExpected", new Object[]{this.connectionId, Integer.toString(n)}), Http2Error.PROTOCOL_ERROR);
        }
        boolean bl = Flags.isEndOfHeaders(n2);
        this.output.headersContinue(n3, bl);
        this.readHeaderPayload(n, n3, byteBuffer);
        this.hpackDecoder.getHeaderEmitter().validateHeaders();
        if (bl) {
            this.headersCurrentStream = -1;
            this.onHeadersComplete(n);
        }
    }

    protected void readPriorityUpdateFrame(int n, ByteBuffer byteBuffer) throws Http2Exception, IOException {
        block6: {
            byte[] byArray = new byte[n];
            if (byteBuffer == null) {
                this.input.fill(true, byArray);
            } else {
                byteBuffer.get(byArray);
            }
            int n2 = ByteUtil.get31Bits(byArray, 0);
            if (n2 == 0) {
                throw new ConnectionException(sm.getString("http2Parser.processFramePriorityUpdate.streamZero"), Http2Error.PROTOCOL_ERROR);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 4, n - 4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, StandardCharsets.US_ASCII));
            try {
                Priority priority = Priority.parsePriority(bufferedReader);
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("http2Parser.processFramePriorityUpdate.debug", new Object[]{this.connectionId, Integer.toString(n2), Integer.toString(priority.getUrgency()), priority.getIncremental()}));
                }
                this.output.priorityUpdate(n2, priority);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!log.isTraceEnabled()) break block6;
                log.trace((Object)sm.getString("http2Parser.processFramePriorityUpdate.invalid", new Object[]{this.connectionId, Integer.toString(n2)}), (Throwable)illegalArgumentException);
            }
        }
    }

    protected void readHeaderPayload(int n, int n2, ByteBuffer byteBuffer) throws Http2Exception, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("http2Parser.processFrameHeaders.payload", new Object[]{this.connectionId, n, n2}));
        }
        int n3 = n2;
        while (n3 > 0) {
            int n4;
            if (this.headerReadBuffer.remaining() == 0) {
                n4 = this.headerReadBuffer.capacity() < n2 ? n2 : this.headerReadBuffer.capacity() * 2;
                this.headerReadBuffer = ByteBufferUtils.expand((ByteBuffer)this.headerReadBuffer, (int)n4);
            }
            n4 = Math.min(this.headerReadBuffer.remaining(), n3);
            if (byteBuffer == null) {
                this.input.fill(true, this.headerReadBuffer, n4);
            } else {
                int n5 = byteBuffer.limit();
                byteBuffer.limit(byteBuffer.position() + n4);
                this.headerReadBuffer.put(byteBuffer);
                byteBuffer.limit(n5);
            }
            this.headerReadBuffer.flip();
            try {
                this.hpackDecoder.decode(this.headerReadBuffer);
            }
            catch (HpackException hpackException) {
                throw new ConnectionException(sm.getString("http2Parser.processFrameHeaders.decodingFailed"), Http2Error.COMPRESSION_ERROR, hpackException);
            }
            this.headerReadBuffer.compact();
            n3 -= n4;
            if (this.hpackDecoder.isHeaderCountExceeded()) {
                StreamException streamException = new StreamException(sm.getString("http2Parser.headerLimitCount", new Object[]{this.connectionId, n}), Http2Error.ENHANCE_YOUR_CALM, n);
                this.hpackDecoder.getHeaderEmitter().setHeaderException(streamException);
            }
            if (this.hpackDecoder.isHeaderSizeExceeded(this.headerReadBuffer.position())) {
                StreamException streamException = new StreamException(sm.getString("http2Parser.headerLimitSize", new Object[]{this.connectionId, n}), Http2Error.ENHANCE_YOUR_CALM, n);
                this.hpackDecoder.getHeaderEmitter().setHeaderException(streamException);
            }
            if (!this.hpackDecoder.isHeaderSwallowSizeExceeded(this.headerReadBuffer.position())) continue;
            throw new ConnectionException(sm.getString("http2Parser.headerLimitSize", new Object[]{this.connectionId, n}), Http2Error.ENHANCE_YOUR_CALM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readUnknownFrame(int n, int n2, int n3, int n4, ByteBuffer byteBuffer) throws IOException {
        try {
            this.swallowPayload(n, n2, n4, false, byteBuffer);
        }
        catch (ConnectionException connectionException) {
        }
        finally {
            this.output.onSwallowedUnknownFrame(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swallowPayload(int n, int n2, int n3, boolean bl, ByteBuffer byteBuffer) throws IOException, ConnectionException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("http2Parser.swallow.debug", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n3)}));
        }
        try {
            if (n3 == 0) {
                return;
            }
            if (!bl && byteBuffer != null) {
                byteBuffer.position(byteBuffer.position() + n3);
            } else {
                int n4;
                byte[] byArray = new byte[1024];
                for (int i = 0; i < n3; i += n4) {
                    n4 = Math.min(byArray.length, n3 - i);
                    if (byteBuffer == null) {
                        this.input.fill(true, byArray, 0, n4);
                    } else {
                        byteBuffer.get(byArray, 0, n4);
                    }
                    if (!bl) continue;
                    for (int j = 0; j < n4; ++j) {
                        if (byArray[j] == 0) continue;
                        throw new ConnectionException(sm.getString("http2Parser.nonZeroPadding", new Object[]{this.connectionId, Integer.toString(n)}), Http2Error.PROTOCOL_ERROR);
                    }
                }
            }
        }
        finally {
            if (FrameType.DATA.getIdByte() == n2) {
                if (bl) {
                    ++n3;
                }
                if (n3 > 0) {
                    this.output.onSwallowedDataFramePayload(n, n3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHeadersComplete(int n) throws Http2Exception {
        if (this.headerReadBuffer.position() > 0) {
            throw new ConnectionException(sm.getString("http2Parser.processFrameHeaders.decodingDataLeft"), Http2Error.COMPRESSION_ERROR);
        }
        this.hpackDecoder.clearHeaderEmitter();
        Output output = this.output;
        synchronized (output) {
            this.output.headersEnd(n, this.headersEndStream);
            if (this.headersEndStream) {
                this.headersEndStream = false;
            }
        }
        if (this.headerReadBuffer.capacity() > 1024) {
            this.headerReadBuffer = ByteBuffer.allocate(1024);
        }
    }

    protected void validateFrame(FrameType frameType, FrameType frameType2, int n, int n2, int n3) throws Http2Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("http2Parser.processFrame", new Object[]{this.connectionId, Integer.toString(n), frameType2, Integer.toString(n2), Integer.toString(n3)}));
        }
        if (frameType != null && frameType2 != frameType) {
            throw new StreamException(sm.getString("http2Parser.processFrame.unexpectedType", new Object[]{frameType, frameType2}), Http2Error.PROTOCOL_ERROR, n);
        }
        int n4 = this.input.getMaxFrameSize();
        if (n3 > n4) {
            throw new ConnectionException(sm.getString("http2Parser.payloadTooBig", new Object[]{Integer.toString(n3), Integer.toString(n4)}), Http2Error.FRAME_SIZE_ERROR);
        }
        if (this.headersCurrentStream != -1) {
            if (this.headersCurrentStream != n) {
                throw new ConnectionException(sm.getString("http2Parser.headers.wrongStream", new Object[]{this.connectionId, Integer.toString(this.headersCurrentStream), Integer.toString(n)}), Http2Error.COMPRESSION_ERROR);
            }
            if (frameType2 != FrameType.RST && frameType2 != FrameType.CONTINUATION) {
                throw new ConnectionException(sm.getString("http2Parser.headers.wrongFrameType", new Object[]{this.connectionId, Integer.toString(this.headersCurrentStream), frameType2}), Http2Error.COMPRESSION_ERROR);
            }
        }
        frameType2.check(n, n3);
    }

    void readConnectionPreface(WebConnection webConnection, Stream stream) throws Http2Exception {
        byte[] byArray = new byte[CLIENT_PREFACE_START.length];
        try {
            this.input.fill(true, byArray);
            for (int i = 0; i < CLIENT_PREFACE_START.length; ++i) {
                if (CLIENT_PREFACE_START[i] == byArray[i]) continue;
                throw new ProtocolException(sm.getString("http2Parser.preface.invalid"));
            }
            this.readFrame(true, FrameType.SETTINGS);
        }
        catch (IOException iOException) {
            throw new ProtocolException(sm.getString("http2Parser.preface.io"), iOException);
        }
    }

    static interface Input {
        public boolean fill(boolean var1, byte[] var2, int var3, int var4) throws IOException;

        default public boolean fill(boolean bl, byte[] byArray) throws IOException {
            return this.fill(bl, byArray, 0, byArray.length);
        }

        default public boolean fill(boolean bl, ByteBuffer byteBuffer, int n) throws IOException {
            boolean bl2 = this.fill(bl, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n);
            if (bl2) {
                byteBuffer.position(byteBuffer.position() + n);
            }
            return bl2;
        }

        public int getMaxFrameSize();
    }

    static interface Output {
        public HpackDecoder getHpackDecoder();

        public ByteBuffer startRequestBodyFrame(int var1, int var2, boolean var3) throws Http2Exception;

        public void endRequestBodyFrame(int var1, int var2) throws Http2Exception, IOException;

        public void receivedEndOfStream(int var1) throws ConnectionException;

        public void onSwallowedDataFramePayload(int var1, int var2) throws ConnectionException, IOException;

        public HpackDecoder.HeaderEmitter headersStart(int var1, boolean var2) throws Http2Exception, IOException;

        public void headersContinue(int var1, boolean var2);

        public void headersEnd(int var1, boolean var2) throws Http2Exception;

        public void reset(int var1, long var2) throws Http2Exception;

        public void setting(Setting var1, long var2) throws ConnectionException;

        public void settingsEnd(boolean var1) throws IOException;

        public void pingReceive(byte[] var1, boolean var2) throws IOException;

        public void goaway(int var1, long var2, String var4);

        public void incrementWindowSize(int var1, int var2) throws Http2Exception;

        public void priorityUpdate(int var1, Priority var2) throws Http2Exception;

        public void onSwallowedUnknownFrame(int var1, int var2, int var3, int var4) throws IOException;

        public void increaseOverheadCount(FrameType var1);
    }
}

