---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, couleur
---

# Comment écrire du texte en couleurs ?

L'extension <ctanpkg:xcolor> (comme, plus anciennement, l'extension 
<ctanpkg:color>) permet de colorier le texte ou le fond du document.
Pour écrire du texte en couleurs, elle fournit deux commandes :

```{noedit}
\textcolor{⟨couleur⟩}{⟨texte à mettre en couleur⟩} % portée       locale
    \color{⟨couleur⟩}                              % portée semi-globale (bascule)
```
où `⟨couleur⟩` peut notamment être l'une des 19 couleurs prédéfinies : `red`
(rouge), `green` (vert), `blue` (bleu), `cyan` (cyan), `magenta` (magenta),
`yellow` (jaune), `black` (noir), `gray` (gris), `white` (blanc), `darkgray`
(gris foncé), `lightgray` (gris clair), `brown` (marron), `lime` (vert citron),
`olive` (olive), `orange` (orange), `pink` (rose), `purple` (pourpre), `teal`
(bleu sarcelle), `violet` (violet).

En voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{xcolor}

\begin{document}
\textcolor{red}{Important !}
Pas important.
{\color{orange} Important !}
Pas important.
\end{document}
```

D'autres jeux de couleurs prédéfinies sont disponibles au moyen d'options
de l'extension <ctanpkg:xcolor> et de nouvelles couleurs peuvent 
[être définies](/3_composition/illustrations/definir_de_nouvelles_couleurs) 
et ce, selon plusieurs modèles de couleurs.

L'extension <ctanpkg:couleurs-fr> permet d'utiliser des noms de couleur
francisés.


```{seealso}
- Au sujet des couleurs, vous pouvez consulter les 
  [Cahier GUTenberg numéro 16 de février 1994](http://www.numdam.org/issues/CG_1994___16/), 
  entièrement consacré à ce problème, et l'article de M. Goossens et M. Jouhet dans le 
  [Cahier GUTenberg numéro 21 (juin 1995, pages 30-52)](http://www.numdam.org/item/CG_1995___21_30_0.pdf).
- toujours sur le thème de la couleur, vous pouvez consulter la question
  "[](/3_composition/texte/paragraphes/griser_l_arriere-plan_d_un_paragraphe)".
```

<!-- - <ctanpkg:pstricks> est un ensemble de macros Postscript compatibles avec Plain -->
<!--   TeX, LaTeX, AmSTeX et AmS-LaTeX. Il comprend notamment des macros pour la -->
<!--   colorisation, la gestion des graphiques, le dessin de camembert, d'arbres, -->
<!--   etc. -->