/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.util.Map;
import org.mvel2.DataConversion;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class MapAccessorNest
implements AccessorNode {
    private AccessorNode nextNode;
    private ExecutableStatement property;
    private Class conversionType;

    public MapAccessorNest() {
    }

    public MapAccessorNest(ExecutableStatement property, Class conversionType) {
        this.property = property;
        this.conversionType = conversionType;
    }

    public MapAccessorNest(String property, Class conversionType) {
        this.property = (ExecutableStatement)ParseTools.subCompileExpression(property.toCharArray());
        this.conversionType = conversionType;
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vrf) {
        if (this.nextNode != null) {
            return this.nextNode.getValue(((Map)ctx).get(this.property.getValue(elCtx, elCtx, vrf)), elCtx, vrf);
        }
        return ((Map)ctx).get(this.property.getValue(elCtx, elCtx, vrf));
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory vars, Object value) {
        if (this.nextNode != null) {
            return this.nextNode.setValue(((Map)ctx).get(this.property.getValue(ctx, elCtx, vars)), elCtx, vars, value);
        }
        if (this.conversionType != null) {
            value = DataConversion.convert(value, this.conversionType);
            ((Map)ctx).put(this.property.getValue(ctx, elCtx, vars), value);
        } else {
            ((Map)ctx).put(this.property.getValue(ctx, elCtx, vars), value);
        }
        return value;
    }

    public ExecutableStatement getProperty() {
        return this.property;
    }

    public void setProperty(ExecutableStatement property) {
        this.property = property;
    }

    @Override
    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public String toString() {
        return "Map Accessor -> [" + this.property + "]";
    }

    @Override
    public Class getKnownEgressType() {
        return Object.class;
    }
}

