/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBinaryPruningImageFilter_h
#define sitkBinaryPruningImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class BinaryPruningImageFilter
\brief This filter removes "spurs" of less than a certain length in the input image.

This class is parameterized over the type of the input image and the type of the output image.

The input is assumed to be a binary image.

This filter is a sequential pruning algorithm and known to be computational time dependable of the image size. The algorithm is the N-dimensional version of that given for two dimensions in:

Rafael C. Gonzales and Richard E. Woods. Digital Image Processing. Addison Wesley, 491-494, (1993).

\see MorphologyImageFilter 


\see BinaryErodeImageFilter 


\see BinaryDilateImageFilter 


\see BinaryThinningImageFilter
\sa itk::simple::BinaryPruning for the procedural interface
\sa itk::BinaryPruningImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BinaryPruningImageFilter : public ImageFilter {
    public:
      using Self = BinaryPruningImageFilter;

      /** Destructor */
      virtual ~BinaryPruningImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BinaryPruningImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = typelist2::typelist<BasicPixelID<uint8_t> >;
\

      /**
       * Set/Get the iteration value
       */
      SITK_RETURN_SELF_TYPE_HEADER SetIteration ( uint32_t Iteration ) { this->m_Iteration = Iteration; return *this; }

      /**
       * Set/Get the iteration value
       */
      uint32_t GetIteration() const { return this->m_Iteration; }

      /** Name of this class */
      std::string GetName() const { return std::string ("BinaryPruningImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      uint32_t  m_Iteration{3u};


    };

    /**\
     * \brief This filter removes "spurs" of less than a certain length in the input image.
     *
     * This function directly calls the execute method of BinaryPruningImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::BinaryPruningImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image BinaryPruning ( const Image& image1, uint32_t iteration = 3u );

     /** @} */
}
#endif
