/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools.grpc;

import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Tag;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ml.MLServerProto;
import org.languagetool.tools.Cache.ProtoResultCache;
import org.languagetool.tools.grpc.ProtoHelper;

public class RuleData
extends Rule {
    private final String id;
    private final String subId;
    private final String description;
    private final int estimateContextForSureMatch;
    private final String sourceFile;

    public RuleData(MLServerProto.Match match) {
        this.id = match.getId();
        this.subId = match.getSubId();
        this.description = match.getRuleDescription();
        this.estimateContextForSureMatch = match.getContextForSureMatch();
        this.sourceFile = match.getRule().getSourceFile();
        if (!match.getRule().getIssueType().isEmpty()) {
            this.setLocQualityIssueType(ITSIssueType.valueOf(match.getRule().getIssueType()));
        }
        if (match.getRule().getTempOff()) {
            this.setDefaultTempOff();
        }
        if (match.getRule().hasCategory()) {
            Category c = new Category(new CategoryId(match.getRule().getCategory().getId()), match.getRule().getCategory().getName());
            this.setCategory(c);
        }
        this.setPremium(match.getRule().getIsPremium());
        this.setTags(match.getRule().getTagsList().stream().map(t -> Tag.valueOf(t.name())).toList());
    }

    public RuleData(ProtoResultCache.CachedRule rule) {
        this.id = rule.getId();
        this.subId = rule.getSubId();
        this.description = rule.getDescription();
        this.estimateContextForSureMatch = rule.getEstimateContextForSureMatch();
        this.sourceFile = rule.getSourceFile();
        if (!rule.getIssueType().isEmpty()) {
            this.setLocQualityIssueType(ITSIssueType.valueOf(rule.getIssueType()));
        }
        if (rule.getTempOff()) {
            this.setDefaultTempOff();
        }
        if (rule.hasCategory()) {
            Category c = new Category(new CategoryId(rule.getCategory().getId()), rule.getCategory().getName());
            this.setCategory(c);
        }
        this.setPremium(rule.getIsPremium());
        this.setTags(rule.getTagsList().stream().map(t -> Tag.valueOf(t.name())).toList());
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return ProtoHelper.emptyAsNull(this.sourceFile);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSubId() {
        return ProtoHelper.emptyAsNull(this.subId);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int estimateContextForSureMatch() {
        return this.estimateContextForSureMatch;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        throw new UnsupportedOperationException("Not implemented; internal class used for returning match information from remote endpoint");
    }
}

