/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.AuxMainVerbForm;
import ai.grazie.rules.en.ClausalComplements;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.NonProgressive;
import ai.grazie.rules.en.PassiveToActive;
import ai.grazie.rules.en.QuantifierNounCompatibility;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.en.UnexpectedVerb;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.en.WordConfusion;
import ai.grazie.rules.en.WordOrder;
import ai.grazie.rules.en.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.TreeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MissingVerb {
    static final String MISSING_VERB_MSG = "Missing verb?";
    private static final String INCORRECT_VERB_FORM_MSG = "Incorrect verb form?";
    private static final String NOUN_VERB_CONFUSION_MSG = "A noun possibly confused with a verb";
    private static final NodePattern born = NodePattern.N.form("born");
    private static final NodePattern withNoBeforeHead = NodePattern.N.withDependent("det|advmod", NodePattern.N.form("no").beforeHead());
    private static final NodePattern insertHave = NodePattern.or(NodePattern.N.onlyPos("NNS?").noPotentialPos("JJ.*"), NodePattern.N.form("much|little")).noDependents("case", NodePattern.N.noDependents()).and(Semantics.Animacy.inanimate.pattern).withDependent("nsubj", Semantics.Animacy.humanLike.pattern);
    private static final NodePattern numberMismatch = NodePattern.or(NodePattern.N.pos("NN").noPotentialPos("JJ.*").withDependent("nsubj", NodePattern.N.form("we|they")), NodePattern.N.pos("NNS").withDependent("nsubj", AgreementSet.onlySgPronoun));
    private static final NodePattern howToX = NodePattern.N.noPotentialPos("VB").pos("NN").directlyAfter(NodePattern.N.form("to").directlyAfter(NodePattern.N.pos("WP|WRB")));
    private static final NodePattern noInsertVerb = NodePattern.or(NodePattern.N.pos("NNS|VBZ"), NodePattern.N.pos("VBG").noHeadRelation("ccomp").andOr(NodePattern.ROOT.directlyBefore(NodePattern.N.onlyPos("NN.*")), NodePattern.N.withDependent("nsubj.*|expl", withNoBeforeHead), NodePattern.N.withDependent("advmod", withNoBeforeHead.form("more"))), NodePattern.N.pos("NNP?S?").withDependent("obj|nsubj:pass"));
    private static final NodePattern nonPassiveContext = NodePattern.or(NodePattern.N.withDependent("obj"), NodePattern.N.withDependent("obl:npmod", NodePattern.N.directlyAfterHead()), NodePattern.N.withHeadRelation("acl:relcl").andOr(NodePattern.N.noDependents("advmod|mark", NodePattern.N.pos("WRB")), NodePattern.N.withDependent("xcomp", EnglishTreePatterns.withToMark), NodePattern.N.withDependent("compound:prt")));
    private static final NodePattern nonVerb = NodePattern.N.pos("NN.*|JJ.*|RB.*|VB[GN]|UH").andOr(NodePattern.N.pos("VBN").withDependent("advmod", NodePattern.N.beforeHead().pos("JJ[RS]")).and(PassiveToActive.hasPassiveLikeArguments), NodePattern.N.noPotentialPos("VB[PZD]?|MD").noDependents(NodePattern.N.beforeHead().noPos().noForm("%|[$\u00a3\u20ac\u00a5\u20bd]")), NodePattern.N.withDependent("det|nmod:poss", NodePattern.N.noForm("both"))).andNot(StyleRules.luv).andNot(Questions.questionWithOmittedAux).andNot(CommonPatterns.quotedWord).andNot(NodePattern.N.lemma("inline").withDependent("obj|nsubj:pass")).andNot(NodePattern.N.onlyPos("JJ").withOnlyDependents(NodePattern.N.withHeadRelation("nsubj").noDependents()).trace("language inclusive")).andNot(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").withDependent("compound", NodePattern.N.potentialPos("VBZ"))).andNot(NodePattern.N.form("more").withDependent("advcl|obl", NodePattern.N.potentialPos("VB.*"))).andNot(NodePattern.N.withDependent("case").withHead("conj|parataxis", NodePattern.or(NodePattern.N.withDependent("obl").trace("main verb ellipsis for different nsubj and obl"), NodePattern.N.withHeadRelation("nmod").trace("misparsed nmod coordination"))));
    private static final NodePattern findAuxAnchor = NodePattern.or(NodePattern.N.withDependent("det", NodePattern.N.directlyAfterHead().form("all")).markAs("Anchor"), NodePattern.N.withDependent("nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case", NodePattern.N.afterHead()).withNextSibling(NodePattern.N.beforeHead().withHeadRelation("obl").withPhraseEnd(NodePattern.N.markAs("Anchor"))), NodePattern.ROOT.withDependent("acl", NodePattern.N.afterHead().withPhraseEnd(CommonPatterns.lastWord)).markAs("Anchor"), NodePattern.N.withPhraseEnd(NodePattern.N.markAs("Anchor")));
    private static final Set<String> rareVerbs = Set.of("belie", "redo");
    private static final NodePattern headClauseVbd = NodePattern.N.withHead("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|conj", EnglishTreePatterns.clause.and(CommonPatterns.possiblySkipDown("cop", NodePattern.N.pos("VBD"))));
    static final Map<String, List<String>> nounsToVerbs = new HashMap<String, List<String>>();
    private static final NodePattern suggestOnlyNoun;

    MissingVerb() {
    }

    private static NodePattern wrongPredicate() {
        NodePattern infinitiveWithTo = NodePattern.N.pos("VB").withDependent("mark", NodePattern.N.form("to")).andOr(NodePattern.N.withHeadRelation("acl:relcl"), NodePattern.N.noDependents("nsubj", Questions.whPhrase));
        NodePattern misparsedCompound = NodePattern.or(NodePattern.N.pos("NN.*"), NodePattern.N.noPos()).withHead(NodePattern.N.potentialPos("NNS?").markAs("CompoundHead")).directlyBeforeHead().withHead(NodePattern.or(NodePattern.N.potentialPos("NN"), NodePattern.N.noDependents("obj"), NodePattern.N.directlyBefore(NodePattern.N.pos("NNS?"))));
        NodePattern whichExactly = NodePattern.or(NodePattern.N.inFormSequence(0, "which", "exactly|particularly|specifically"), NodePattern.N.inFormSequence(0, "which", "in", "particular"));
        return NodePattern.or(nonVerb, infinitiveWithTo).markAs("Predicate").withDependent("nsubj(:pass)?|expl", NodePattern.N.beforeHead().pos("NN.*|PRP_S.+|P?DT|WP").noForm("twas").andNot(misparsedCompound).andNot(whichExactly).andNot(CommonPatterns.quotedWord).andNot(CommonPatterns.personMentionEnd).andNot(NodePattern.N.withDependent("punct", CommonPatterns.HYPHEN_LIKE_NODE.before("Predicate"))).andNot(CommonPatterns.capitalizedMiddle.withDependent("compound", CommonPatterns.capitalizedMiddle)).noDependents("nmod", QuantifierNounCompatibility.misparsedALotOfNounVerb).markAs("Subj")).andOr(NodePattern.not(CommonPatterns.possiblySkipDown("mark", NodePattern.or(NodePattern.N.withDependent("cop|aux|aux:pass"), NodePattern.N.withDependent("ccomp", NodePattern.N.lemma("be").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl"))))), NodePattern.N.withDependent("cop", NodePattern.N.form("in|on").correct(NodeCorrector.replace("is")))).andOr(NodePattern.N.noHeadRelation("dep|xcomp|advcl|acl|parataxis|amod|appos"), NodePattern.N.pos("VBG|NN.*").withHeadRelation("advcl").withDependent("mark|advmod", NodePattern.N.pos("CC").noPos("RP").before("Subj")).andNot(NodePattern.N.withDependent("obj", NodePattern.N.withDependent("amod", NodePattern.N.pos("VBN")))), NodePattern.N.withHeadRelation("parataxis").andOr(NodePattern.N.pos("NN.*"), NodePattern.N.withDependent("det|nmod:poss"))).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.startsWithApostrophe.form(".s"))).andOr(NodePattern.not(NodePattern.N.withHeadRelation("advmod")), EnglishTreePatterns.withThatMark).noForm("scrum").andNot(NodePattern.N.withHead("acl:relcl", NodePattern.N.pos("WP"))).andNot(NodePattern.N.pos("JJR").withDependent("det")).andNot(CommonPatterns.possiblyConj(NodePattern.N.potentialPos("VBG").andOr(CommonPatterns.beforeSkipping(NodePattern.N.pos("RB.*"), NodePattern.N.potentialPos("VBD")), NodePattern.N.withHeadRelation("csubj|acl"), NodePattern.N.withHead("ccomp", NodePattern.not(NodePattern.N.lemma("agree|appear|arrange|ask|attempt|beg|afford|care|chance|choose|claim|consent|dare|decide|demand|deserve|determine|elect|endeavor|expect|fail|guarantee|hesitate|hope|hurry|incline|manage|neglect|offer|plan|prepare|pretend|proceed|profess|promise|prove|refuse|request|resolve|seek|shudder|strive|struggle|swear|tend|threaten|venture|volunteer|wait|wish|yearn"))).andNot(EnglishTreePatterns.withThatMark), NodePattern.ROOT.withDependent("advcl", NodePattern.N.noDependents("mark"))))).andNot(NodePattern.N.withHead("conj", NodePattern.or(NodePattern.N.withDependent("xcomp", NodePattern.N.withDependent("mark", NodePattern.N.form("to"))).pos("VB").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?"), NodePattern.N.withHeadRelation("xcomp|acl.*|obj|advcl(:relcl)?|conj|amod|advmod|appos"), NodePattern.not(NodePattern.N.pos("VBG")).withDependent("cop|aux|aux:pass", NodePattern.N.lemma("be").pos("VB[DZP]?"))))).andNot(NodePattern.N.withHeadRelation("csubj").withDependent("mark")).andNot(NodePattern.N.pos("JJ.*").withHead("conj", NodePattern.N.withDependent("xcomp", NodePattern.N.pos("JJ.*")))).andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("for")).withDependent("mark", NodePattern.N.form("to"))).andNot(CommonPatterns.capitalized.withDependent("nsubj", CommonPatterns.capitalized)).andNot(WordSeparation.phrasalVerbAsNoun).andNot(NodePattern.N.form("not").withHead("conj", NodePattern.N.pos("RB").noDependents("cop|aux|aux:pass"))).noDependents("advmod", NodePattern.N.withDependent("cop")).noDependents("parataxis", NodePattern.N.beforeHead().after("Subj")).noDependents("compound", NodePattern.N.pos("VBZ").after("Subj")).noDependents("discourse", NodePattern.N.pos("VB.*").beforeHead().after("Subj")).noDependents("mark", CommonPatterns.firstWord.form("with")).noDependents("expl", NodePattern.N.after("Subj")).andNot(NodePattern.N.withDependent("nsubj", NodePattern.or(NodePattern.N.inFormSequence(0, "what", "a"), NodePattern.N.form("being").noDependents(), WordConfusion.youYourTypo.directlyBeforeHead()))).andNot(NodePattern.N.withHeadRelation("parataxis").withDependent("nsubj", NodePattern.N.form("all").directlyBefore(NodePattern.N.withHeadRelation("case"))).trace("many Xs (all of type Y)")).andNot(NodePattern.N.withHead("conj", NodePattern.not(EnglishTreePatterns.verbalClause).trace("misparsed NP coordination: 'stgn, prod coming next week'"))).and(MissingVerb.fixMissingVerb()).and((node, match) -> match.concedingToOtherGrammarCheckers()).trace("wrong predicate");
    }

    private static NodePattern nounAfterXTo() {
        return howToX.withHead(CommonPatterns.possiblySkipUp("obj", NodePattern.N.withDependent("nsubj", NodePattern.N.markAs("Subj")))).includeIntoReport().and(MissingVerb.fixMissingVerb());
    }

    private static List<String> suggestVerbsByNouns(Node predicate, Node subj) {
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        for (String lemma : predicate.lemmaReadings()) {
            for (String verb : nounsToVerbs.getOrDefault(lemma, List.of())) {
                TreeSupport support = predicate.tree().treeSupport();
                if (!support.tagToken(verb).hasPos("VB")) continue;
                VerbInflectionNumber in = VerbInflectionNumber.from(predicate, subj);
                if (in == VerbInflectionNumber.singular && !howToX.matches(predicate)) {
                    suggestions.addAll(support.synthesize(verb, verb, "VB", "VBZ"));
                } else {
                    suggestions.add(verb);
                }
                if (!predicate.lowForm().endsWith("t")) continue;
                suggestions.addAll(support.synthesize(verb, verb, "VB", "VBD"));
            }
        }
        return new ArrayList<String>(suggestions);
    }

    private static NodePattern rootSubject() {
        return NodePattern.ROOT.pos("PRP|NN.*").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|cop|conj").markAs("Subj").andOr(NodePattern.N.withDependent("acl", NodePattern.N.pos("VBG").markAs("Predicate").directlyAfterHead().withDependent("xcomp").andNot(ClausalComplements.requiringCompSubject.noDependents("i?obj").withDependent("xcomp", EnglishTreePatterns.withToMark)).and(MissingVerb.fixMissingVerb())), NodePattern.N.withDependent("amod|appos", NodePattern.N.markAs("Predicate").afterHead().andOr(NodePattern.N.withDependent("det|ccomp"), EnglishTreePatterns.negated).andNot(CommonPatterns.capitalized).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").noMatchUntil("Subj", NodePattern.PUNCT).withPhraseStart(NodePattern.N.includeIntoReport().directlyAfter(NodePattern.N.includeIntoReport())).and(MissingVerb.insertCopulaBeforePredicate())).noPotentialPos("CD").noDependents(NodePattern.N.between("Subj", "Predicate").noHeadRelation("nmod")).andNot(CommonPatterns.severalDependents("appos"))).andNot(CommonPatterns.insideQuotes).andNot(CommonPatterns.inAllCapitalizedSentence).trace("root subject");
    }

    static NodePattern pattern() {
        NodePattern imperative = nonVerb.andOr(EnglishTreePatterns.rootAfterPlease.and((node, match) -> node.similarWordsOfPos("VB").findFirst().map(s -> EnglishTreePatterns.typoReplacement(s).match(node, match)).orElse(null)), NodePattern.ROOT.and(EnglishTreePatterns.withoutSubject).withDependent("cop", CommonPatterns.firstWord.form("bee").and(EnglishTreePatterns.typoReplacement("be"))));
        return NodePattern.or(MissingVerb.wrongPredicate(), MissingVerb.rootSubject(), MissingVerb.nounAfterXTo(), NodePattern.or(MissingVerb.faultyCoordination(), MissingVerb.missingVerbInQuestions()).message(MISSING_VERB_MSG), imperative).andNot(NodePattern.N.pos("VBG").withDependent("nsubj", NodePattern.N.form("fancy")));
    }

    private static NodePattern faultyCoordination() {
        return NodePattern.N.pos("VBG").withHead("conj", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.markAs("Subj")).noDependents("cop|aux:pass").withOptionalDependent("aux", EnglishTreePatterns.baseAux.markAs("BaseAux")).markAs("MainVerb")).withDependent("cc", NodePattern.N.form("and|or").beforeHead().directlyAfter(CommonPatterns.comma).noDependents().markAs("CC").withNeighbor(-2, NodePattern.not(NodePattern.N.inPhrase(NodePattern.N.pos("NN.*|VBG").between("MainVerb", "CC").withHeadRelation("conj"))))).noDependents("cop|aux|aux:pass|nsubj(:pass|:outer)?|csubj(:pass)?|expl|mark|case").noDependents("advmod", NodePattern.N.form("when")).andNot(NodePattern.N.withDependent("ccomp", NodePattern.N.pos("VB[ZD]").withDependent("cop|aux|aux:pass"))).andNot(NodePattern.N.after(NodePattern.N.pos("VBG"))).and((node, match) -> {
            Node mainVerb = match.getMarkedNode("MainVerb");
            boolean needsBase = match.findMarkedNode("BaseAux") != null;
            String beForm = needsBase ? "be" : VerbInflectionNumber.from(mainVerb, match.getMarkedNode("Subj")).sameTense(mainVerb).inflectBe();
            match = match.withCorrector(NodeCorrector.insertBefore(node, beForm + " "));
            if (needsBase) {
                match = match.withCorrector(NodeCorrector.inflect(node, "VBG", "VB"));
            }
            return match;
        }).andOptionally(NodePattern.N.withDependent("advmod", NodePattern.N.directlyAfter("CC")).and(NodePattern.markedNodeMatches("MainVerb", NodePattern.N.withDependent("advmod", NodePattern.N.afterHead()))).correct(NodeCorrector.insertAfterPrevious(","))).correct(NodeCorrector.replace(NodePointer.marked("CC"), ""));
    }

    private static NodePattern missingVerbInQuestions() {
        NodePattern missingLexicalVerb = NodePattern.ROOT.andOr(TreeMigration.revise("try removing this condition", NodePattern.N.anyPos().noPotentialPos("VB.*").andNot(EnglishTreePatterns.unlikelyToBeNoun).withDependent("aux", NodePattern.N.lemma("do|have"))).withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", Questions.whPhrase), NodePattern.N.lemma("do|have").noDependents("cop|aux|aux:pass|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|mark").withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.withDependent("det", Questions.whWord)).withPhraseEnd(NodePattern.N.directlyAfter(CommonPatterns.lastWord.includeIntoReport()))).and(CommonPatterns.withQuestionMark);
        NodePattern missingBe = NodePattern.N.pos("VBG").and(Questions.questionWithOmittedAux).and(WordOrder.fixMissingAux());
        return NodePattern.or(missingLexicalVerb, missingBe).trace("missing verb in questions");
    }

    @Nullable
    private static NodeMatch handleNmodAmbiguity(Node head, NodeMatch match, Node prep, Node subj) {
        match = match.withMessage(MISSING_VERB_MSG);
        if (prep.hasForm("as")) {
            return match.withCorrector(NodeCorrector.replace(prep, List.of("is", "was")));
        }
        if (prep.hasForm("before")) {
            String wasWere = VerbInflectionNumber.from(head, subj).past(true).inflectBe();
            return match.withCorrector(NodeCorrector.insertAfter(prep, " " + wasWere));
        }
        return null;
    }

    @NotNull
    private static String inflectBe(Node subj, Node predicate) {
        boolean past = born.matches(predicate) && predicate.tree().nodes().stream().noneMatch(n -> n.hasPos("VB[ZP]"));
        return VerbInflectionNumber.from(predicate, subj).past(past).inflectBe();
    }

    private static NodePattern insertCopulaBeforePredicate() {
        return NodePattern.custom((predicate, match) -> {
            Node subj = match.getMarkedNode("Subj");
            Node predicateStart = predicate.phraseStart();
            String beForm = VerbInflectionNumber.from(predicate, subj).past(false).inflectBe();
            return match.withCorrector(NodeCorrector.insertBefore(predicateStart, beForm + " ")).withMessage(MISSING_VERB_MSG);
        });
    }

    private static NodePattern fixMissingVerb() {
        NodePattern allowSuggestionsAfterLemmaChange = NodePattern.N.pos("JJ|UH").noDependents(NodePattern.not(NodePattern.PUNCT).afterHead());
        NodePattern predicativeAdj = NodePattern.N.pos("JJ").withHeadRelation("root|[xc]comp").noDependents("obj|discourse").andNot(Semantics.unlikelyToBeAdj).andNot(Semantics.attributiveOnlyAdj);
        NodePattern anPossibleTypo = NodePattern.ROOT.potentialPos("JJ").withDependent("det", NodePattern.N.form("an"));
        return NodePattern.custom((head, match) -> {
            String expectedVerbPos;
            Optional fromSpeller;
            List<String> verbsByNouns;
            boolean canInsertVerb;
            Node subj = match.getMarkedNode("Subj");
            match = match.withSuppressableKind(NodeMatch.SuppressableKind.INCOMPLETE_SENTENCE);
            Node prep = head.findSingleDependent("case");
            if (prep != null && head.head() == null && prep == subj.nextNode()) {
                return MissingVerb.handleNmodAmbiguity(head, match, prep, subj);
            }
            VerbInflectionNumber number = VerbInflectionNumber.fromLikely(head, subj);
            Node subjEnd = subj.phraseEnd();
            boolean bl = canInsertVerb = (!noInsertVerb.matches(head) || subjEnd.nextNode() != head) && !numberMismatch.matches(head);
            if (((StreamEx)subjEnd.nextUntil(head).filter(n -> CommonPatterns.comma.matches((Node)n))).count() % 2L != 0L) {
                return null;
            }
            Node auxAnchor = Objects.requireNonNull(findAuxAnchor.match(subj)).getMarkedNode("Anchor");
            if (head.hasPos("VB[NG]")) {
                if (head.hasPos("VBN") && !born.matches(head) && !PassiveToActive.hasPassiveLikeArguments.matches(head)) {
                    match = match.withCorrector(NodeCorrector.replace(head, head.tree().treeSupport().inflectNode(head, "VBN", "VBD")));
                    if (number != null) {
                        match = match.withCorrector(NodeCorrector.insertAfter(auxAnchor, " " + number.past(false).inflectHave()));
                    }
                    if (nonPassiveContext.matches(head) || AuxMainVerbForm.nonPassive.matches(head)) {
                        return match.withMessage(INCORRECT_VERB_FORM_MSG);
                    }
                }
                if (EnglishTreePatterns.subjunctiveExpected.matches(head) && head.hasPos("VBG")) {
                    return match.withCorrector(NodeCorrector.inflect(head, "VBG", "VBP")).withMessage(INCORRECT_VERB_FORM_MSG);
                }
                if (NonProgressive.noSuggestions.matches(head) && head.hasPos("VBG")) {
                    String expectedVerbPos2;
                    String string = expectedVerbPos2 = number == VerbInflectionNumber.singular ? "VBZ" : "VBP";
                    if (headClauseVbd.matches(head)) {
                        return match.withCorrector(NodeCorrector.inflect(head, "VBG", "VBD")).withMessage(INCORRECT_VERB_FORM_MSG).concedingToOtherGrammarCheckers();
                    }
                    return match.withCorrector(NodeCorrector.inflect(head, "VBG", expectedVerbPos2)).withMessage(INCORRECT_VERB_FORM_MSG);
                }
            }
            if (!(verbsByNouns = MissingVerb.suggestVerbsByNouns(head, subj)).isEmpty() && !head.hasDependent("det")) {
                match = match.withCorrector(NodeCorrector.replace(head, verbsByNouns));
                if (suggestOnlyNoun.matches(head)) {
                    return match.withMessage(NOUN_VERB_CONFUSION_MSG);
                }
            }
            if (number != null && subj.nextNode() == head && !head.hasPos("VB.*") && !predicativeAdj.matches(head) && (fromSpeller = head.similarWordsOfPos(expectedVerbPos = number == VerbInflectionNumber.singular ? "VB[ZD]" : "VB[PD]").findFirst(s -> head.tree().treeSupport().tagToken((String)s).lemmaReadings().stream().noneMatch(rareVerbs::contains))).isPresent()) {
                if (!allowSuggestionsAfterLemmaChange.matches(head)) {
                    return match.withCorrector(NodeCorrector.replace(head, (String)fromSpeller.get())).withMessage(MISSING_VERB_MSG);
                }
                match = match.withCorrector(NodeCorrector.replace(head, (String)fromSpeller.get()));
            }
            if (!canInsertVerb || EnglishValences.lacksObligatoryArguments.matches(head)) {
                return match.correctors().isEmpty() ? null : match.withMessage(NOUN_VERB_CONFUSION_MSG);
            }
            if (subjEnd == subj && subj.lowForm().equals("bee")) {
                match = match.withCorrector(NodeCorrector.replace(subj, "be"));
            }
            boolean noSuggestInIt = subj.hasForm("she|he") & Semantics.Animacy.inanimate.pattern.matches(head);
            if (prep != null && prep.hasForm("in") && !noSuggestInIt) {
                match = match.withCorrector(NodeCorrector.replace(prep, "is"));
            }
            if (subj.hasForm("this") && head.hasPos("NNS")) {
                return match.withCorrector(NodeCorrector.replace(subj, "these are")).withMessage(MISSING_VERB_MSG);
            }
            if (insertHave.matches(head)) {
                String have = VerbInflectionNumber.from(head, subj).past(headClauseVbd.matches(head)).inflectHave();
                return match.withCorrector(NodeCorrector.insertAfter(auxAnchor, " " + have)).withMessage(MISSING_VERB_MSG);
            }
            if (anPossibleTypo.matches(head)) {
                return null;
            }
            if (Articles.requiresArticle.formPattern.matches(head) && !head.hasDependent("det|nmod:poss") && subj.hasPos("PRP")) {
                return null;
            }
            match = match.withReportedNodes(auxAnchor, auxAnchor.nextNode());
            if (headClauseVbd.matches(head)) {
                String copulaPast = VerbInflectionNumber.from(head, subj).past(true).inflectBe();
                match = match.withCorrector(NodeCorrector.insertAfter(auxAnchor, " " + copulaPast));
            }
            String copula = MissingVerb.inflectBe(subj, head);
            if (!howToX.matches(head)) {
                match = match.withCorrector(NodeCorrector.insertAfter(auxAnchor, " " + copula));
            }
            return match.withMessage(MISSING_VERB_MSG);
        });
    }

    static {
        for (Map.Entry<String, List<String>> entry : UnexpectedVerb.verbsToNouns.entrySet()) {
            for (String noun : entry.getValue()) {
                nounsToVerbs.computeIfAbsent(noun, __ -> new ArrayList()).add(entry.getKey());
            }
        }
        nounsToVerbs.put("extension", List.of("extend"));
        nounsToVerbs.put("fin", List.of("find"));
        nounsToVerbs.put("posse", List.of("possess"));
        suggestOnlyNoun = NodePattern.or(NodePattern.N.withDependent("obj|advmod"), howToX);
    }
}

