/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.dot.DotData;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterManager;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.GraphvizImageBuilder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.InnerActivity;
import net.sourceforge.plantuml.svek.image.EntityImageState;

public final class GroupMakerActivity {
    private final CucaDiagram diagram;
    private final Entity group;
    private final StringBounder stringBounder;
    private final DotMode dotMode;
    private final Rose rose = new Rose();

    public GroupMakerActivity(CucaDiagram diagram, Entity group, StringBounder stringBounder, DotMode dotMode) {
        this.diagram = diagram;
        this.group = group;
        this.stringBounder = stringBounder;
        this.dotMode = dotMode;
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            Entity e1 = link.getEntity1();
            Entity e2 = link.getEntity2();
            if (e1.getParentContainer() != this.group || e1.isGroup() || e2.getParentContainer() != this.group || e2.isGroup()) continue;
            result.add(link);
        }
        return result;
    }

    public final StyleSignatureBasic getDefaultStyleDefinitionGroup() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.group);
    }

    public IEntityImage getImage() throws IOException, InterruptedException {
        if (this.group.countChildren() == 0) {
            return new EntityImageState(this.group);
        }
        List<Link> links = this.getPureInnerLinks();
        ISkinParam skinParam = this.diagram.getSkinParam();
        Bibliotekon bibliotekon = new Bibliotekon(links);
        DotData dotData = new DotData(this.diagram, this.group, links, this.group.leafs(), new InnerGroupHierarchy(), PortionShower.ALL);
        Cluster root = new Cluster(this.group.getLocation(), this.diagram, bibliotekon.getColorSequence(), dotData.getRootGroup());
        ClusterManager clusterManager = new ClusterManager(bibliotekon, root);
        DotStringFactory dotStringFactory = new DotStringFactory(bibliotekon, root, this.diagram.getUmlDiagramType(), this.diagram.getSkinParam());
        GraphvizImageBuilder svek2 = new GraphvizImageBuilder(dotData, this.diagram.getSource(), this.diagram.getPragma(), SName.activityDiagram, this.dotMode, dotStringFactory, clusterManager);
        if (this.group.getGroupType() == GroupType.INNER_ACTIVITY) {
            Stereotype stereo = this.group.getStereotype();
            HColor borderColor = this.getColor(ColorParam.activityBorder, stereo);
            HColor backColor = this.group.getColors().getColor(ColorType.BACK) == null ? this.getColor(ColorParam.background, stereo) : this.group.getColors().getColor(ColorType.BACK);
            Style style = this.getDefaultStyleDefinitionGroup().getMergedStyle(skinParam.getCurrentStyleBuilder());
            double shadowing = style.getShadowing();
            return new InnerActivity(svek2.buildImage(this.stringBounder, null, new String[0], false), borderColor, backColor, shadowing);
        }
        throw new UnsupportedOperationException(this.group.getGroupType().toString());
    }

    protected final HColor getColor(ColorParam colorParam, Stereotype stereo) {
        ISkinParam skinParam = this.diagram.getSkinParam();
        return this.rose.getHtmlColor(skinParam, stereo, colorParam);
    }

    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Entity getRootGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Entity> getChildrenGroups(Entity parent) {
            if (parent.isRoot()) {
                return GroupMakerActivity.this.diagram.getChildrenGroups(GroupMakerActivity.this.group);
            }
            return GroupMakerActivity.this.diagram.getChildrenGroups(parent);
        }

        @Override
        public boolean isEmpty(Entity g) {
            return GroupMakerActivity.this.diagram.isEmpty(g);
        }
    }
}

