"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URI = exports.UI_SETTINGS = exports.SEARCH_STRATEGY = exports.S3_PARTITION_INFO_COLUMN = exports.RESOURCE_TYPES = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENSEARCH_API = exports.ERROR_DETAILS = exports.DATASET = exports.BASE_API_ASSISTANT = exports.BASE_API = exports.API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'queryEnhancements';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'queryEnhancements';
const BASE_API = exports.BASE_API = '/api/enhancements';
const BASE_API_ASSISTANT = exports.BASE_API_ASSISTANT = '/api/assistant';
const DATASET = exports.DATASET = {
  S3: 'S3',
  PROMETHEUS: 'PROMETHEUS'
};
const SEARCH_STRATEGY = exports.SEARCH_STRATEGY = {
  PPL: 'ppl',
  PPL_RAW: 'pplraw',
  PROMQL: 'promql',
  SQL: 'sql',
  SQL_ASYNC: 'sqlasync',
  PPL_ASYNC: 'pplasync'
};
const API = exports.API = {
  SEARCH: `${BASE_API}/search`,
  PPL_SEARCH: `${BASE_API}/search/${SEARCH_STRATEGY.PPL}`,
  PROMQL_SEARCH: `${BASE_API}/search/${SEARCH_STRATEGY.PROMQL}`,
  SQL_SEARCH: `${BASE_API}/search/${SEARCH_STRATEGY.SQL}`,
  SQL_ASYNC_SEARCH: `${BASE_API}/search/${SEARCH_STRATEGY.SQL_ASYNC}`,
  PPL_ASYNC_SEARCH: `${BASE_API}/search/${SEARCH_STRATEGY.PPL_ASYNC}`,
  QUERY_ASSIST: {
    LANGUAGES: `${BASE_API}/assist/languages`,
    GENERATE: `${BASE_API}/assist/generate`
  },
  DATA_SOURCE: {
    ASYNC_JOBS: `${BASE_API}/jobs`,
    CONNECTIONS: `${BASE_API}/connections`,
    REMOTE_CLUSTER: {
      LIST: `${BASE_API}/remote_cluster/list`,
      INDEXES: `${BASE_API}/remote_cluster/indexes`
    }
  },
  AGENT_API: {
    CONFIG_EXISTS: `${BASE_API_ASSISTANT}/agent_config/_exists`
  }
};
const URI = exports.URI = {
  PPL: '/_plugins/_ppl',
  SQL: '/_plugins/_sql',
  ASYNC_QUERY: '/_plugins/_async_query',
  DIRECT_QUERY: {
    QUERY: '/_plugins/_directquery/_query',
    RESOURCES: '/_plugins/_directquery/_resources'
  },
  ML: '/_plugins/_ml',
  OBSERVABILITY: '/_plugins/_observability',
  DATA_CONNECTIONS: '/_plugins/_query/_datasources'
};
const OPENSEARCH_API = exports.OPENSEARCH_API = {
  PANELS: `${URI.OBSERVABILITY}/object`,
  DATA_CONNECTIONS: URI.DATA_CONNECTIONS
};
const UI_SETTINGS = exports.UI_SETTINGS = {
  QUERY_ENHANCEMENTS_ENABLED: 'query:enhancements:enabled',
  STATE_STORE_IN_SESSION_STORAGE: 'state:storeInSessionStorage'
};
const ERROR_DETAILS = exports.ERROR_DETAILS = {
  GUARDRAILS_TRIGGERED: 'guardrails triggered'
};
const S3_PARTITION_INFO_COLUMN = exports.S3_PARTITION_INFO_COLUMN = '# Partition Information';
const RESOURCE_TYPES = exports.RESOURCE_TYPES = {
  PROMETHEUS: {
    LABELS: 'labels',
    LABEL_VALUES: 'label_values',
    METRICS: 'metrics',
    METRIC_METADATA: 'metric_metadata',
    SERIES: 'series',
    ALERTS: 'alerts',
    ALERTS_GROUPS: 'alert_manager_alert_groups',
    RULES: 'rules'
  }
};