(window["tileMap_bundle_jsonpfunction"]=window["tileMap_bundle_jsonpfunction"]||[]).push([[2],{14:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"GeohashLayer",(function(){return geohash_layer_GeohashLayer}));var external_osdSharedDeps_Lodash_=__webpack_require__(3);var external_osdSharedDeps_Lodash_default=__webpack_require__.n(external_osdSharedDeps_Lodash_);var external_osdSharedDeps_OsdI18n_=__webpack_require__(0);var public_=__webpack_require__(1);var d3=__webpack_require__(12);var d3_default=__webpack_require__.n(d3);var events=__webpack_require__(13);class heatmap_HeatmapMarkers extends events["EventEmitter"]{constructor(featureCollection,options,zoom,max,leaflet){super();this._geojsonFeatureCollection=featureCollection;const points=dataToHeatArray(featureCollection,max);this._leafletLayer=new leaflet.HeatLayer(points,options);this._tooltipFormatter=options.tooltipFormatter;this._zoom=zoom;this._disableTooltips=false;this._getLatLng=external_osdSharedDeps_Lodash_default.a.memoize((function(feature){return leaflet.latLng(feature.geometry.coordinates[1],feature.geometry.coordinates[0])}),(function(feature){return[feature.geometry.coordinates[1],feature.geometry.coordinates[0]].join(",")}));this._addTooltips()}getBounds(){return this._leafletLayer.getBounds()}getLeafletLayer(){return this._leafletLayer}appendLegendContents(){}movePointer(type,event){if(type==="mousemove"){this._debounceMoveMoveLocation(event)}else if(type==="mouseout"){this.emit("hideTooltip")}else if(type==="mousedown"){this._disableTooltips=true;this.emit("hideTooltip")}else if(type==="mouseup"){this._disableTooltips=false}}_addTooltips(){const mouseMoveLocation=e=>{if(!this._geojsonFeatureCollection.features.length||this._disableTooltips){this.emit("hideTooltip");return}const feature=this._nearestFeature(e.latlng);if(this._tooltipProximity(e.latlng,feature)){const content=this._tooltipFormatter(feature);if(!content){return}this.emit("showTooltip",{content:content,position:e.latlng})}else{this.emit("hideTooltip")}};this._debounceMoveMoveLocation=external_osdSharedDeps_Lodash_default.a.debounce(mouseMoveLocation.bind(this),15,{leading:true,trailing:false})}_nearestFeature(latLng){const self=this;let nearest;if(latLng.lng<-180||latLng.lng>180){return}external_osdSharedDeps_Lodash_default.a.reduce(this._geojsonFeatureCollection.features,(function(distance,feature){const featureLatLng=self._getLatLng(feature);const dist=latLng.distanceTo(featureLatLng);if(dist<distance){nearest=feature;return dist}return distance}),Infinity);return nearest}_tooltipProximity(latlng,feature){if(!feature)return;let showTip=false;const featureLatLng=this._getLatLng(feature);const zoomScale=d3_default.a.scale.linear().domain([1,4,7,10,13,16,18]).range([1e6,3e5,1e5,15e3,2e3,150,50]);const proximity=zoomScale(this._zoom);const distance=latlng.distanceTo(featureLatLng);const maxLngDif=40;const lngDif=Math.abs(latlng.lng-featureLatLng.lng);if(distance<proximity&&lngDif<maxLngDif){showTip=true}d3_default.a.scale.pow().exponent(.2).domain([1,18]).range([15e5,50]);return showTip}}function dataToHeatArray(featureCollection,max){return featureCollection.features.map(feature=>{const lat=feature.geometry.coordinates[1];const lng=feature.geometry.coordinates[0];const heatIntensity=feature.properties.value/max;return[lat,lng,heatIntensity]})}var external_osdSharedDeps_Jquery_=__webpack_require__(11);var external_osdSharedDeps_Jquery_default=__webpack_require__.n(external_osdSharedDeps_Jquery_);var charts_public_=__webpack_require__(4);class scaled_circles_ScaledCirclesMarkers extends events["EventEmitter"]{constructor(featureCollection,featureCollectionMetaData,options,targetZoom,opensearchDasbhoardsMap,leaflet){super();this._featureCollection=featureCollection;this._featureCollectionMetaData=featureCollectionMetaData;this._zoom=targetZoom;this._valueFormatter=options.valueFormatter||(x=>{x});this._tooltipFormatter=options.tooltipFormatter||(x=>{x});this._label=options.label;this._colorRamp=options.colorRamp;this._legendColors=null;this._legendQuantizer=null;this._leaflet=leaflet;this._popups=[];const layerOptions={pointToLayer:this.getMarkerFunction(),style:this.getStyleFunction(),onEachFeature:(feature,layer)=>{this._bindPopup(feature,layer)}};if(!options.isFilteredByCollar){layerOptions.filter=feature=>{const bucketRectBounds=feature.properties.geohash_meta.rectangle;return opensearchDasbhoardsMap.isInside(bucketRectBounds)}}this._leafletLayer=this._leaflet.geoJson(null,layerOptions);this._leafletLayer.addData(this._featureCollection)}getLeafletLayer(){return this._leafletLayer}getStyleFunction(){const min=external_osdSharedDeps_Lodash_default.a.get(this._featureCollectionMetaData,"min",0);const max=external_osdSharedDeps_Lodash_default.a.get(this._featureCollectionMetaData,"max",1);const quantizeDomain=min!==max?[min,max]:d3_default.a.scale.quantize().domain();this._legendColors=this.getLegendColors();this._legendQuantizer=d3_default.a.scale.quantize().domain(quantizeDomain).range(this._legendColors);return makeStyleFunction(this._legendColors,quantizeDomain)}movePointer(){}getLabel(){if(this._popups.length){return this._label}return""}appendLegendContents(jqueryDiv){if(!this._legendColors||!this._legendQuantizer){return}const titleText=this.getLabel();const $title=external_osdSharedDeps_Jquery_default()("<div>").addClass("visMapLegend__title").text(titleText);jqueryDiv.append($title);this._legendColors.forEach(color=>{const labelText=this._legendQuantizer.invertExtent(color).map(this._valueFormatter).join(" – ");const label=external_osdSharedDeps_Jquery_default()("<div>");const icon=external_osdSharedDeps_Jquery_default()("<i>").css({background:color,"border-color":makeColorDarker(color)});const text=external_osdSharedDeps_Jquery_default()("<span>").text(labelText);label.append(icon);label.append(text);jqueryDiv.append(label)})}_bindPopup(feature,layer){const popup=layer.on({mouseover:e=>{const layer=e.target;if(!this._leaflet.Browser.ie&&!this._leaflet.Browser.opera){layer.bringToFront()}this._showTooltip(feature)},mouseout:()=>{this.emit("hideTooltip")}});this._popups.push(popup)}_showTooltip(feature){const content=this._tooltipFormatter(feature);if(!content){return}const latLng=this._leaflet.latLng(feature.geometry.coordinates[1],feature.geometry.coordinates[0]);this.emit("showTooltip",{content:content,position:latLng})}getMarkerFunction(){const scaleFactor=.6;return(feature,latlng)=>{const value=feature.properties.value;const scaledRadius=this._radiusScale(value)*scaleFactor;return this._leaflet.circleMarker(latlng).setRadius(scaledRadius)}}_radiusScale(value){const precisionBiasBase=5;const precisionBiasNumerator=200;const precision=external_osdSharedDeps_Lodash_default.a.max(this._featureCollection.features.map(feature=>String(feature.properties.geohash).length));const pct=Math.abs(value)/Math.abs(this._featureCollectionMetaData.max);const zoomRadius=.5*Math.pow(2,this._zoom);const precisionScale=precisionBiasNumerator/Math.pow(precisionBiasBase,precision);return Math.pow(pct,.5)*zoomRadius*precisionScale}getBounds(){return this._leafletLayer.getBounds()}getLegendColors(){const colorRamp=external_osdSharedDeps_Lodash_default.a.get(charts_public_["truncatedColorMaps"][this._colorRamp],"value");return public_["colorUtil"].getLegendColors(colorRamp)}}function makeColorDarker(color){const amount=1.3;return d3_default.a.hcl(color).darker(amount).toString()}function makeStyleFunction(legendColors,quantizeDomain){const legendQuantizer=d3_default.a.scale.quantize().domain(quantizeDomain).range(legendColors);return feature=>{const value=external_osdSharedDeps_Lodash_default.a.get(feature,"properties.value");const color=legendQuantizer(value);return{fillColor:color,color:makeColorDarker(color),weight:1.5,opacity:1,fillOpacity:.75}}}class shaded_circles_ShadedCirclesMarkers extends scaled_circles_ScaledCirclesMarkers{getMarkerFunction(){const scaleFactor=.8;return(feature,latlng)=>{const radius=this._geohashMinDistance(feature)*scaleFactor;return this._leaflet.circle(latlng,radius)}}_geohashMinDistance(feature){const centerPoint=feature.properties.geohash_meta.center;const geohashRect=feature.properties.geohash_meta.rectangle;const east=this._leaflet.latLng([centerPoint[0],geohashRect[2][1]]);const north=this._leaflet.latLng([geohashRect[3][0],centerPoint[1]]);const center=this._leaflet.latLng([centerPoint[0],centerPoint[1]]);const eastRadius=Math.floor(center.distanceTo(east));const northRadius=Math.floor(center.distanceTo(north));return external_osdSharedDeps_Lodash_default.a.min([eastRadius,northRadius])}}class geohash_grid_GeohashGridMarkers extends scaled_circles_ScaledCirclesMarkers{getMarkerFunction(){return feature=>{const geohashRect=feature.properties.geohash_meta.rectangle;const corners=[[geohashRect[3][0],geohashRect[3][1]],[geohashRect[1][0],geohashRect[1][1]]];return this._leaflet.rectangle(corners)}}}class geohash_layer_GeohashLayer extends public_["OpenSearchDashboardsMapLayer"]{constructor(featureCollection,featureCollectionMetaData,options,zoom,opensearchDashboardsMap,leaflet){super();this._featureCollection=featureCollection;this._featureCollectionMetaData=featureCollectionMetaData;this._geohashOptions=options;this._zoom=zoom;this._opensearchDashboardsMap=opensearchDashboardsMap;this._leaflet=leaflet;const geojson=this._leaflet.geoJson(this._featureCollection);this._bounds=geojson.getBounds();this._createGeohashMarkers();this._lastBounds=null}_createGeohashMarkers(){const markerOptions={isFilteredByCollar:this._geohashOptions.isFilteredByCollar,valueFormatter:this._geohashOptions.valueFormatter,tooltipFormatter:this._geohashOptions.tooltipFormatter,label:this._geohashOptions.label,colorRamp:this._geohashOptions.colorRamp};switch(this._geohashOptions.mapType){case public_["MapTypes"].ScaledCircleMarkers:this._geohashMarkers=new scaled_circles_ScaledCirclesMarkers(this._featureCollection,this._featureCollectionMetaData,markerOptions,this._zoom,this._opensearchDashboardsMap,this._leaflet);break;case public_["MapTypes"].ShadedCircleMarkers:this._geohashMarkers=new shaded_circles_ShadedCirclesMarkers(this._featureCollection,this._featureCollectionMetaData,markerOptions,this._zoom,this._opensearchDashboardsMap,this._leaflet);break;case public_["MapTypes"].ShadedGeohashGrid:this._geohashMarkers=new geohash_grid_GeohashGridMarkers(this._featureCollection,this._featureCollectionMetaData,markerOptions,this._zoom,this._opensearchDashboardsMap,this._leaflet);break;case public_["MapTypes"].Heatmap:let radius=15;if(this._featureCollectionMetaData.geohashGridDimensionsAtEquator){const minGridLength=Object(external_osdSharedDeps_Lodash_["min"])(this._featureCollectionMetaData.geohashGridDimensionsAtEquator);const metersPerPixel=this._opensearchDashboardsMap.getMetersPerPixel();radius=minGridLength/metersPerPixel/2}radius=radius*parseFloat(this._geohashOptions.heatmap.heatClusterSize);this._geohashMarkers=new heatmap_HeatmapMarkers(this._featureCollection,{radius:radius,blur:radius,maxZoom:this._opensearchDashboardsMap.getZoomLevel(),minOpacity:.1,tooltipFormatter:this._geohashOptions.tooltipFormatter},this._zoom,this._featureCollectionMetaData.max,this._leaflet);break;default:throw new Error(external_osdSharedDeps_OsdI18n_["i18n"].translate("tileMap.geohashLayer.mapTitle",{defaultMessage:"{mapType} mapType not recognized",values:{mapType:this._geohashOptions.mapType}}))}this._geohashMarkers.on("showTooltip",event=>this.emit("showTooltip",event));this._geohashMarkers.on("hideTooltip",event=>this.emit("hideTooltip",event));this._leafletLayer=this._geohashMarkers.getLeafletLayer()}appendLegendContents(jqueryDiv){return this._geohashMarkers.appendLegendContents(jqueryDiv)}movePointer(){this._geohashMarkers.movePointer(...arguments)}async getBounds(){if(this._geohashOptions.fetchBounds){const geoHashBounds=await this._geohashOptions.fetchBounds();if(geoHashBounds){const northEast=this._leaflet.latLng(geoHashBounds.top_left.lat,geoHashBounds.bottom_right.lon);const southWest=this._leaflet.latLng(geoHashBounds.bottom_right.lat,geoHashBounds.top_left.lon);return this._leaflet.latLngBounds(southWest,northEast)}}return this._bounds}updateExtent(){if(!this._geohashOptions.isFilteredByCollar){const bounds=this._opensearchDashboardsMap.getLeafletBounds();if(!this._lastBounds||!this._lastBounds.equals(bounds)){this._opensearchDashboardsMap.removeLayer(this);this._createGeohashMarkers();this._opensearchDashboardsMap.addLayer(this)}this._lastBounds=bounds}}isReusable(options){if(Object(external_osdSharedDeps_Lodash_["isEqual"])(this._geohashOptions,options)){return true}if(this._geohashOptions.colorRamp!==options.colorRamp){return false}else if(this._geohashOptions.mapType!==options.mapType){return false}else if(this._geohashOptions.mapType==="Heatmap"&&!Object(external_osdSharedDeps_Lodash_["isEqual"])(this._geohashOptions.heatmap,options)){return false}else{return true}}}}}]);