/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.stream.read;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.io.InputStreamContainer;

@ExperimentalApi
public class ReadContext {
    private final long blobSize;
    private final List<StreamPartCreator> asyncPartStreams;
    private final String blobChecksum;
    private final Map<String, String> metadata;

    private ReadContext(long blobSize, List<StreamPartCreator> asyncPartStreams, String blobChecksum, Map<String, String> metadata) {
        this.blobSize = blobSize;
        this.asyncPartStreams = asyncPartStreams;
        this.blobChecksum = blobChecksum;
        this.metadata = metadata;
    }

    public ReadContext(ReadContext readContext) {
        this.blobSize = readContext.blobSize;
        this.asyncPartStreams = readContext.asyncPartStreams;
        this.blobChecksum = readContext.blobChecksum;
        this.metadata = readContext.metadata;
    }

    public String getBlobChecksum() {
        return this.blobChecksum;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int getNumberOfParts() {
        return this.asyncPartStreams.size();
    }

    public long getBlobSize() {
        return this.blobSize;
    }

    public List<StreamPartCreator> getPartStreams() {
        return this.asyncPartStreams;
    }

    public static class Builder {
        private final long blobSize;
        private final List<StreamPartCreator> asyncPartStreams;
        private String blobChecksum;
        private Map<String, String> metadata;

        public Builder(long blobSize, List<StreamPartCreator> asyncPartStreams) {
            this.blobSize = blobSize;
            this.asyncPartStreams = asyncPartStreams;
        }

        public Builder blobChecksum(String blobChecksum) {
            this.blobChecksum = blobChecksum;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ReadContext build() {
            return new ReadContext(this.blobSize, this.asyncPartStreams, this.blobChecksum, this.metadata);
        }
    }

    @FunctionalInterface
    @ExperimentalApi
    public static interface StreamPartCreator
    extends Supplier<CompletableFuture<InputStreamContainer>> {
        @Override
        public CompletableFuture<InputStreamContainer> get();
    }
}

